function sflag = Var_Stable(B)
%__________________________________________________________________________
% dd = Var_Stable(B)
%
% Checks stability conditions for VAR
% INPUT B     Matrix of coefficients (without constant) n x n*p 
%             Format: B(1:n,(j-1)*n+1:j*n) contains lag j coeffs
% OUTPUT      sflag = TRUE if VAR is stable
%__________________________________________________________________________
 [n,m]  =  size(B); 
  p     =  m/n;
  
% Create companion form
  A        = zeros(p*n,p*n);
  A(1:n,:) = B;
  if p > 1 
     for j = 2:p
         A((j-1)*n+1:j*n,(j-2)*n+1:(j-1)*n) = eye(n);
     end 
  end
  
% Obtain largest eigenvalue & check 
  opts.tol   = 1e-3; 
  opts.maxit = 1e3;
  try      [v,d]   = eigs(A,1,'LM',opts); 
  catch,   sflag   = false;
           return
  end
    
  if abs(d)> 0.97   ; sflag = false;
  else                sflag = true;
  end