
function ix = SC_draws(SC,W_,B_)
%__________________________________________________________________________
% function ix = SC_draws(SC)
% Select from draws SC(1:ndraws) with probability W_. Probability W_ is
% represented as a vector nbin x 1 with support B_
%
% INPUT
%   SC         Vector of                                            [n x 1]
%   W_         Probability measure                               [nbin x 1]
%   B_         Support of probability measure                    [nbin x 1]
%
% OUTPUT
%   ix         Index of chosen draws                                [n x 1]
%__________________________________________________________________________
  n  = length(SC);
  w  = zeros(n,1);
  
  for i = 1:n
      ii    = find(SC(i) < B_,1);
      if isempty(ii)
         ii = length(W_);
      end
      w(i) = W_(ii);
  end
  ix = w > rand(n,1);
 