
function [W_, B_] = SC_Weights(Method,O)
%__________________________________________________________________________
% function (W_,B_) = SC_Weights(type,O)
%__________________________________________________________________________
% Generate the acceptance weights for sign concrdance outcomes
% h may be a vector to add a restriction for a set of horizons
%
%  INPUTS
%  Method     1 = SC threshold  with             O.cut in (0.5,1) 
%             2 = SC Beta(a,b) distribution w    O.a  and O.b  > 0 
%                    a > b gives right-skew                                          
%                    b < 1 gives mode at x=1  
%             3 = Binomial(nz,O.p) distribution
%             4 = SC based on model with two shocks
%             5 = FEVD threshold  with           O.cut > 1  
%             6 = FEVD weights based on model with 2 shocks
%
% OUTPUT      W_  Probabilities                              [n_bin x 1]
%             B_  Support of W_                              [n_bin x 1]
%
%             The support of W_ is set to (0,1) for SC
%                                     and (0,3) for FEVD
%__________________________________________________________________________
 SUF = 3.0;                               % Upper bound of support for FEVD
 if ~isfield(O,'ndraws')
     O.ndraws = 5000; 
 end  
 
 switch Method 
 case {5,6};   n_bin   = 101;    U_bin   = SUF;
 otherwise;    n_bin   = 101;    U_bin   = 1.0;
 end
 W_  = zeros(1,n_bin);
 B_  = linspace(0,U_bin,n_bin);
 
 switch Method
 case {1,5}
       W_(B_ > O.cut) =  1;     
 
 case{2}
      for i = 1:n_bin
          W_(i) = cdf('Beta',B_(i),O.a,O.b);
      end
      
 case{3}
      for i = 1:n_bin
          W_(i) = cdf('Binomial',floor(B_(i)*O.nz),O.nz,O.pz);
      end
      
 case{4}
    for i = 1:O.ndraws 
        eta    =  randn(O.nz,1);
        nu     =  randn(O.nz,1) * O.sig ;
        SC     =  sign(eta+nu) == sign(nu);
      
        SC     =  sum(SC) ./ O.nz;
        ix     =  find(SC <= B_,1);
        W_(ix) =  W_(ix) + 1;
    end    
    W_ = W_ ./ sum(sum(W_)); 
    W_ = cumsum(W_);
     
 case{6}   
    for i = 1:O.ndraws 
        eta    =  randn(O.T,1);
        nu0    =  randn(O.nz,1) * O.sig;
        z      =  ceil(rand(SUF*O.nz,1) * O.T);
        z      =  unique(z,'stable');
        z      =  z(1:O.nz);
        nu     =  zeros(O.T,1);
        nu(z)  =  nu0;
        
        FC     =  std(eta + nu) ./ std(eta);
        ix     =  find(FC <= B_,1);
        W_(ix) =  W_(ix) + 1;
    end    
    W_    = W_ ./ sum(sum(W_)); 
    W_    = cumsum(W_);

 end

