
function [Accept, f] = SC_Accept(SC,n,p,M)
%__________________________________________________________________________
% function [f, Accept] = SC_Accept(SC,n,p,M)
% 
% INPUT
%   SC         Sign concordance  (the NUMBER of events)             [1 x 1]
%   n          Nr of observations                                   [1 x 1]
%   p          Prior on prob of SC                                  [1 x 1]
%   M          Constant weighting term (calibrate M = max(f))       [1 x 1]
%
% OUTPUT
%   f          Probability value (pdf) of binom                     [1 x 1]
%   Accept     0 / 1 random acceptance                              [1 x 1] 
%__________________________________________________________________________
  if isnan(SC), return, end
  
  if isempty(M)
       f      = SC >= n*p; 
       Accept = logical(f);
  else 
       f  =  pdf('Binomial',SC,n,p);
       if f/M > 1, warning(['f > M, n = ' num2str(n)]),end
       Accept = (f/M >= rand);
       
     % disp(['SC = ' num2str(SC)])
     % disp(['n  = ' num2str(n)])
     % disp(['p  = ' num2str(p)])
     % disp(['f  = ' num2str(f)])
     % pause
  end
