function [FV,MSE] = FEVD(L,flag)
%_________________________________________________________________________
% [FV,MSE] = FEVD(L,flag)
%_________________________________________________________________________
% Computes the forecast error variance decomposition of a VAR model
% INPUT
%
%   L(h,i,j)   IRF of var i to shock j in period h-1       [h x n x n_shk]
%              (note that L(:,:,0) ist stored in 1!)
%
%  flag        = 1 => return FV as % of total MSE                [logical]
%
% OUPUT
%   FV(h,i,j)  Contribution of shock j to fcst error 
%              in var i at h (%)                           [h x n x n_shk]
%   MS(h,i)    Overall mean squared fcst error of i at h           [h x n]
%__________________________________________________________________________
  FV  = nan(size(L)); 

  FV(1,:,:) = squeeze(L(1,:,:)).^2;
  for h = 2:size(L,1)
      FV(h,:,:) = squeeze(FV(h-1,:,:)) + squeeze(L(h,:,:)).^2;
  end
  
  MSE = sum(FV,3); 
  
  if flag
     for h = 1:size(L,1)
     for i = 1:size(L,2)
         FV(h,i,:) = FV(h,i,:) ./ MSE(h,i);
     end
     end
  end
 