function [F,f] = Build_Ff(Aplus,A0,h_RR,J)
%__________________________________________________________________________
% INPUT   
% VAR     y(t)'A0 = X(t)'Aplus + u(t)   where X(t) = (y'(t-1),y'(t-2),..)
%
% h_RR     Vector of horizons
%          h_RR is assumed to be sorted and complete: h_RR = [1:maxh] 
%          or h_RR = [1:maxh 100], where 100 stands for the long run
%  J       = [eye(n);repmat(zeros(n),p-1,1)];
%
% OUTPUT
% F       Companion form of VAR y(t) 
% f       Impulse responses
%__________________________________________________________________________
  n   =  size(A0,1);
  p   =  size(Aplus,1) / n;
  A_  =  inv(A0);
  
% Build F for calculating IRFs (before rotation) (p.8)
  F = zeros(n*p,n*p);
  for l  = 1:p
      Ap = Aplus(1+(l-1)*n:l*n,1:end)* A_;
      F(1+(l-1)*n:l*n,1:n) = Ap; 
  end
  if  p >= 2
      F(1:n*(p-1),(n+1):end) = eye(n*(p-1)); 
  end
    
% Find max horizon & check for long run (100)  
% Check completeness of vector h_RR  
  nh  = size(h_RR,1);
  h8  = (h_RR(nh) == 100);
  
  if nh > 1 && nh-2 ~= h_RR(end-1)
     warning('Horizon vector h_RR may be incomplete')
  end
  
% Calculate IRF & MSE 
% if h8 then add long run   
  f = zeros(n*nh,n);
  f(1:n,:) = A_';
  
  for h = 2:(nh-h8)
      f(1+n*(h-1):n*h,:) = J'*(F'^(h-1))*J*A_';
  end
  
  if h8
     Lh = zeros(n,n);
     for l = 1:p 
        Lh = Lh + Aplus(1+(l-1)*n:l*n,1:end)'; 
     end
     f(1+(nh-1)*n:n*nh,:) = inv(eye(n)-A_'*Lh) * A_';
  end