function f2 = Build_FEV(f,qj,h_RR)
%__________________________________________________________________________
% function f2 = Build_FEV(f,qj,h_RR)
%__________________________________________________________________________
% Calculates forecast error variances based on the IRF f for horizons h_RR. 
% h_RR = 100 stands for the long run.
% Set qj = 1 to obtain the full MSE of the endog vars
% For n x 1 vector qj the function calculates teh contribution to MSE %
% shock from shock e_j as obtained by the rotation vector qj.
%
% INPUT 
%  f       f(1+n*(h-1):n*h,:) is the IRF at horizon h-1            [nh x n]
%  qj      Rotation vector qj for shock j (from Gram-Schmidt)       [n x 1]
%          Set qj = 1 to obtain the full MSE 
%
%  h_RR    Vector of horizons
%          h_RR must be sorted and complete: h_RR = [0:maxh] 
%          or h_RR = [0:maxh 100]; 100 stands for the long run
%
% OUTPUT
% f2       MSE (due to shock j) for horizons listed in vector h_RR
%__________________________________________________________________________
  n   = size(f,2);

% Find max horizon excl long run (100)  
  nh  = size(h_RR,1);
  h8  = (h_RR(nh) == 100);
  f2  = zeros(n,nh);  

  if qj == 1
     S   = 1;
     f2(:,1) = diag(f(1:n,:)*S*f(1:n,:)');
     for h = 2:(nh-h8)
         Lh = f(1+n*(h-1):n*h,:);
         f2(:,h) = f2(:,h-1) + diag(Lh*S*Lh');
     end
     if h8
       Lh = f(1+(nh-1)*n:n*nh,:);
       f2(:,nh) = diag(Lh*S*Lh');
     end  
      
  else    
    Lh  = f(1:n,:)*qj;
    f2(:,1) = Lh.^2;
    for h = 2:(nh-h8)
        Lh = f(1+n*(h-1):n*h,:)*qj;
        f2(:,h) = f2(:,h-1) + Lh.^2;
    end
    if h8
       Lh = f(1+n*(nh-1):n*nh,:)*qj;
       f2(:,nh) = Lh.^2;
    end 
  end
  
  
  
% _______________________________________________________________  
% ALTERNATIVE METHODS JUST FOR THE RECORDS
% _______________________________________________________________  
% This gives the full covariance matrix of forecast errors
% Set S=eye(n) to get the full MSE of y(t+h)
% _______________________________________________________________  
%  f2  = zeros(size(f));  
%  S   = qj*qj';
% 
%  f2(1:n,:) = f(1:n,:)*S*f(1:n,:)';
%  for h = 2:(nh-h8)
%      Lh = f(1+n*(h-1):n*h,:);
%      f2(1+n*(h-1):n*h,:) = f2(1+n*(h-2):n*(h-1),:) + Lh*S*Lh';
%  end
%   
% % Add long run   
%   if h8
%      Lh = f(1+(nh-1)*n:n*nh,:);
%      f2(1+(nh-1)*n:n*nh,:) = Lh*S*Lh';
%   end   
%  


