
function R_ = Add_R(R_,Y_name,S_name,y,s,type,val,h)
%__________________________________________________________________________
% function R_  = Add_R(R_,Y_name,S_name,y,s,type,val,h)
%__________________________________________________________________________
% Add a zero, sign or FEVD restrictions to list R_
% h may be a vector to add a restriction for a set of horizons
%
% For an FEVD restriction set val in (0,1) for a lower bound, i.e. the
% restriction that the contribution of the shock is larger than val. Set
% it in (-1,0) to define an upper bound (abs(val))
%
%
%  INPUTS
%  R_         Existing list of restrictions       (set R_ = [] @ 1st call)
%  Y_name     N x 1 vector of series labels              [cell of strings]
%  S_name     k x 1 vector of shock labels               [cell of strings]
%  y          Series label                                        [string]
%  s          Shock  label                                        [string]
%  type       0 = zero restriction
%             1 = sign restriction
%             2 = FEVD restriction
%
%  val        type = 0  => val = 0              (irrelevant)
%             type = 1  => val = {+/-1}         (i.e the sign)
%             type = 2  => val in (-1,1)        (> 0 shock contr > abs(val))  
%                                               (< 0 shock contr < abs(val))
%  h          Horizons                                [vector of integers]
%             0 <= h(i) <= 100
%             h = 100 stands for long-run restriction
%__________________________________________________________________________

 y_i  = find(strcmp(Y_name,y));
 u_i  = find(strcmp(S_name,s));

 if isempty(y_i)  error(['Variable ' y ' not found in series labels'])
 end
 if isempty(u_i)  error(['Shock    ' s ' not found in shocks labels'])
 end
 
 if  (type==1) && ~(val==1 || val==-1) 
      error(['Sign restriction must be in {-1,1}'])
 end
 if  (type==1) && ~(val==1 || val==-1) 
      error(['Sign restriction must be in {-1,1}'])
 end
 
 for j = 1:length(h)     
     R_ = [R_; u_i y_i type val h(j)];
 end