function VARci = myProxySVARci(VAR,clevel,method,nboot)

% Method  1: Mertens and Ravn (2014) wild bootstrap 
%         2: Montiel-Olea Stock Watson (2016) bootstrap
%         3: Delta Method 
%         4: Montiel-Olea Stock Watson (2016) asy weak IV
%         5: Jentsch Lunsford MBB 

% Dimension of VARci.irsH and VARci.irsL: 
% 1: horizon 2: # of variables 3: clevel 4: shock (if more than one shock with instrument)

  VARci.irsL = NaN*zeros([size(VAR.irs) length(clevel)]);
  VARci.irsH = NaN*zeros([size(VAR.irs) length(clevel)]);

    if method == 1    
       VARci = myWildbootstrap(VAR,nboot,clevel); 
elseif method == 2
       VARci = myMSWbootstrap(VAR,nboot,clevel,VAR.NWlags);   
elseif method == 3
       error('method = 3 is not implemented')
     % if     VAR.k==1
     %        VARci = doDeltaMethod(VAR,clevel,VAR.NWlags); % n.a. for k>1
     % elseif VAR.k==2
     % VARci = doDeltaMethod_2shock(VAR,clevel,VAR.NWlags);
     % end
elseif method == 4 
       error('method = 4 is not implemented')
     % VARci = myMSWwivrobust(VAR,clevel,VAR.NWlags);       % n.a. for k>1
elseif method == 5
       BlockSize = 5;
       VARci = myMBBbootstrap(VAR,nboot,clevel,BlockSize);    
end

if VAR.k == 1
[~,What,~] = CovAhat_Sigmahat_Gamma(VAR.p,VAR.X(:,[end end-size(VAR.DET,2)+1:end-1 1:VAR.n*VAR.p]),VAR.m,VAR.res',VAR.NWlags);                
 Gamma     = VAR.res'*VAR.m./VAR.T; 
VARci.Waldstat = (((VAR.T^.5)*Gamma(1,1))^2)/What(((VAR.n^2)*VAR.p)+1,((VAR.n^2)*VAR.p)+1);
end
