function VARci = myMSWbootstrap(VAR,nboot,clevel,NWlags)
[Whatall,~,V] = CovAhat_Sigmahat_Gamma(VAR.p,VAR.X(:,[end end-size(VAR.DET,2)+1:end-1 1:VAR.n*VAR.p]),VAR.m,VAR.res',NWlags);                

  AL          = VAR.bet(1:end-size(VAR.DET,2),:)';
  Sigma       = VAR.Sigma;
  Gamma       = VAR.res'*VAR.m./VAR.T; 

% Make sure that Whatall is symmetric and positive semidefinite
  Whatall     = (Whatall + Whatall')/2;     
  [aux1,aux2] = eig(Whatall);     
  Whatall     = aux1*max(aux2,0)*aux1'; 

% Generate draws from the Gaussian asy. dist. 
% (centered at point estimators)
  dall    =  size(Whatall,1);
  gvar    =  mvnrnd(zeros(nboot,dall),(Whatall)/VAR.T)';
            % Added an extra column of zeros to access point estimators       
  Draws   =  bsxfun(@plus,gvar,[AL(:);V*Sigma(:);Gamma(:)]);
 
% Evaluate the parameter of interest 
% (which is allowed to depend on the full vector vecA, vechSigma, Gamma)
  pdSigma   = zeros(1,nboot);
  IRFs      = zeros(VAR.n, VAR.irhor, nboot);
    
 for idraws = 1:nboot   
       AL   = reshape(Draws(1:(VAR.n^2)*VAR.p,idraws),[VAR.n,VAR.n*VAR.p]);        % Generate the draws for AL    
  vechSigma = Draws((VAR.n^2)*VAR.p+1:(VAR.n^2)*VAR.p+(VAR.n*(VAR.n+1)/2),idraws); % Generate the draws from Sigma
      Sigma = tril(ones(VAR.n),0); Sigma(Sigma==1) = vechSigma';       
      Sigma = Sigma + tril(Sigma,-1)';
      
    % Check if the draws are positive definite
      if min(eig(Sigma))>0
          pdSigma(1,idraws) = 1;      
          Gamma = reshape(Draws(((VAR.n^2)*VAR.p)+(VAR.n*(VAR.n+1)/2)+1:end,idraws),[VAR.n,VAR.k]); %Draws from Gamma                        
        % IRFs(:,:,idraws) = doIRFs(AL,Sigma,Gamma,VAR,-1)';
        
          IRS = myIRFs(AL,Gamma',VAR);
          for i=1:size(VAR.irs,3) 
              IRFs(:,:,idraws,i) = IRS(:,:,i)';   
          end
      end 
  end
 
% Implement "Standard" Bootstrap Inference
  aux   = reshape(pdSigma,[1,1,nboot]);
  
  for jj = 1:length(clevel)
    for i=1:size(VAR.irs,3)
        bootsIRFs  = quantile(IRFs(:,:,aux==1,i),...
                           [((1-clevel(jj)/100)/2),1-((1-clevel(jj)/100)/2)],3); 
        VARci.irsH(:,:,jj,i) = bootsIRFs(:,:,1)';
        VARci.irsL(:,:,jj,i) = bootsIRFs(:,:,2)';
    end
  end

% Compute the difference between the estimators obtained from SigmaTu and SigmaTl
  if VAR.k > 1
  for jj = 1:length(clevel)

    auxdiff             = quantile( IRFs(:,:,aux==1,1)-IRFs(:,:,aux==1,4), ...
                          [((1-clevel(jj)/100)/2),1-((1-clevel(jj)/100)/2)],3 );
    auxdiff2            = quantile( IRFs(3,:,aux==1,1)-IRFs(4,:,aux==1,4), ...
                          [((1-clevel(jj)/100)/2),1-((1-clevel(jj)/100)/2)],3 );
    VARci.diffH(:,:,jj) = auxdiff(:,:,1)'; 
    VARci.diffL(:,:,jj) = auxdiff(:,:,2)';
    size(auxdiff2)
    VARci.diffH2(:,jj) = auxdiff2(:,:,1)'; 
    VARci.diffL2(:,jj) = auxdiff2(:,:,2)';

  end
  end

