function LPIV = myLPIV_3(LPIV)
%__________________________________________________________________________
% This estimates the LP-IV model both from OLS and iV
%    Y_{t+h} = y__*b1+ X*b2 + u    with instruments Z for Y (see l 45-46)
%          
%    Here Y_{t+h} is the vector of endog variables as from the VAR
%         y__     is the key variable (log(1-AMTR) in the paper)
%
% I did 4 changes
% (1) The instrument is also the regressor in my case
%     Solution: introduce Zflag and set YY = ZZ if Zflag = 1
% (2) If d_ix(j) = 1 then 1st diffs of X(:,j) are taken 
%     The equation changes to Y_{t+h,j} - Y_{t-1,j} = y__*b1+ X*b2 + u  
% (3) Revert scale to scale = + 1 !
% (4) Adjust the sample such that it's the same for all runs!
%     That is I have to cut off at the end of the sample
%
% Note A/B = inv(A)B
% INPUT
% LPIV.vars                  Dependent variables (as from the VAR)  
%                            Col 1 contains y__ the var to be instrumented
% LPIV.DET                   Further control variables (not instrumented)
% LPIV.taxshocks             The instrument(s)
% LPIV.p                     nr of lags 
% LPIV.irhor                 nr of leads  (k in equation 9)
%__________________________________________________________________________
% Dependent vars and the 1st lag
  yy    = LPIV.vars(LPIV.p+2:end,:);                   
  yy1   = lagmatrix(LPIV.vars,1); 
  yy1   =     yy1(LPIV.p+2:end,:); 
 
% Controls: form lag matrix
  XX2   = LPIV.vars;                                            
  for j = 1:size(XX2,2)
      if LPIV.d_ix(j) == 1
          XX2(:,j) = LPIV.vars(:,j) - lagmatrix(LPIV.vars(:,j),1);
      end
  end    
  XX    = lagmatrix(XX2,1:LPIV.p);              
  XX    = [XX(LPIV.p+2:end,:) LPIV.DET(LPIV.p+2:end,:)];
      
% Instrument Z and key explanatory variable  
% Zflag = 1 Use ZZ itself       as endogenous regressor
% Zflag = 0 Use LPIV.vars(:,1)  as endogenous regressor (M&M)
  ZZ    = LPIV.taxshocks(LPIV.p+2:end,:);                     
  if LPIV.Zflag,  YY = ZZ;                                            
  else            YY = LPIV.vars(LPIV.p+2:end,1);                    
  end
  
  [LPIV.T,LPIV.n] = size(yy);
  LPIV.k          = size(XX,2)+size(YY,2);

  IRFs            = zeros(LPIV.irhor,LPIV.n);
  IRFs_ols        = zeros(LPIV.irhor,LPIV.n);
  LPIV.OmegaSTATA = zeros(2,2,LPIV.n,LPIV.irhor);
  LPIV.gammah     = zeros(LPIV.irhor,LPIV.n);
  LPIV.gamma1     = zeros(LPIV.irhor,1);

  for h = 0:LPIV.irhor-1
      
  % LPIV.d_ix(i) == 1 use yy(h) - yy(-1)
    y = yy((1+h):end,:);
    for j = 1:size(y,2)
        if LPIV.d_ix(j) == 1   
           y(:,j) = yy((1+h):end,j) - yy1(1:(end-h),j);
        end
    end
    Y  = YY(1:(end-h), :); %Y_t      t=1,...,T-h
    X  = XX(1:(end-h), :); %X_t      t=1,...,T-h
    Z  = ZZ(1:(end-h), :); %z_t      t=1,...,T-h

  % Eliminate the last obs to have identical sample for all  
    Y  = Y(1:(end-(LPIV.irhor-h)), :);
    X  = X(1:(end-(LPIV.irhor-h)), :);
    Z  = Z(1:(end-(LPIV.irhor-h)), :);
    y  = y(1:(end-(LPIV.irhor-h)), :);
     
  % Omit RHS regressor with zero variability (other than const) 
    varX = var(X);
    X(:,[varX(:,1:end-1) 1]<eps) = [];
 
  % Just-Identified IV
    IVcoeffs     =          ([X';Z']*[X,Y])\([X';Z']*y);
    OLScoeffs    =          ([X';Y']*[X,Y])\([X';Y']*y);
    u            = Y-[X,Z] *(([X';Z']*[X,Z])\([X';Z']*Y));   
    e            = y-[X,Y] * IVcoeffs;
    
    IRFs(1+h,:)     =   IVcoeffs(end,:);  
    IRFs_ols(1+h,:) =  OLScoeffs(end,:);
  
  % Some Additional Statistics for Later Use
    XXp    = (X'*X)./(LPIV.T-h);
    ZXp    = (Z'*X)./(LPIV.T-h);
    A      = [ -ZXp/XXp, 1 , zeros(1,size(XXp,1)), 0 ; ...
                zeros(1,size(XXp,1))   , 0 , -ZXp/XXp,1];
   
    M      =  eye((LPIV.T-LPIV.irhor))-X*((X'*X)\X');
    ZMZp   = (Z'*M*Z/(LPIV.T-h));
    Zu     =  Z.*u;
    Xu     =  X.*kron(u,ones(1,size(X,2)));      % adj for older ML version
 
    for n = 1:LPIV.n
      Xe    =  X.*kron(e(:,n),ones(1,size(X,2)));
      W     = ((LPIV.T-h)/((LPIV.T-h)-LPIV.k)) ... 
              * NW_hac_STATA([Xe,Z.*e(:,n),Xu,Zu],LPIV.NWlags);
      LPIV.OmegaSTATA(:,:,n,1+h) = A*W*A'./(ZMZp^2);
    end
    LPIV.gamma1(1+h,:) = ZMZp\(Z'*M*Y./(LPIV.T-h));
  end

  scale          =  1;
  LPIV.irs       =  scale*IRFs;
  LPIV.irs_ols   =  scale*IRFs_ols;




