function LPIV = myLPIV(LPIV)
%__________________________________________________________________________
% This estimates the LP-IV model both from OLS and iV
%    Y_{t+h} = y__*b1+ X*b2 + u    with instruments Z for Y (see l 45-46)
%          
%    Here Y_{t+h} is the vector of endog variables as from the VAR
%         y__     is the key variable (log(1-AMTR) in the paper)
%                                           
%
% Note A/B = inv(A)B
% INPUT
% LPIV.vars                  Dependent variables (as from the VAR)  
%                            Col 1 contains y__ the var to be instrumented
% LPIV.DET                   Further control variables (not instrumented)
% LPIV.taxshocks             The instrument(s)
% LPIV.p                     nr of lags 
% LPIV.irhor                 nr of leads  (k in equation 9)
%__________________________________________________________________________
  
   yy1   = lagmatrix(LPIV.vars,1); 
   yy1   =     yy1(LPIV.p+1:end,:); 
   
   
%  for dx also form 
% 
%

  yy    = LPIV.vars(LPIV.p+1:end,:);                     % outcome variables
  
  XX    = lagmatrix(LPIV.vars(:,1:end),1:LPIV.p);        
  XX    = [XX(LPIV.p+1:end,:) LPIV.DET(LPIV.p+1:end,:)]; % controls
  ZZ    = LPIV.taxshocks(LPIV.p+1:end,:);                % instruments
  
% = 1 Use ZZ itself       as endogenous regressor
% = 0 Use LPIV.Vvasr(:,1) as endogenous regressor (M&M)
  if LPIV.Zflag                                         
     YY = ZZ;                                            
  else
     YY = LPIV.vars(LPIV.p+1:end,1);                    
  end
  
  [LPIV.T,LPIV.n] = size(yy);
  LPIV.k          = size(XX,2)+size(YY,2);

  IRFs            = zeros(LPIV.irhor,LPIV.n);
  IRFs_ols        = zeros(LPIV.irhor,LPIV.n);
  LPIV.OmegaSTATA = zeros(2,2,LPIV.n,LPIV.irhor);
  LPIV.gammah     = zeros(LPIV.irhor,LPIV.n);
  LPIV.gamma1     = zeros(LPIV.irhor,1);

  for h = 0:LPIV.irhor-1
      
    % Somehow like this for the entire vector simultaneously
    % But I also have to difference the respective X(:,i) above
    % if LPIV.dx   y = yy((1+h):end, :) - yy1(1:(end-h), :);
    % else         y = yy((1+h):end, :);
    % end
    %
    %
   
    y = yy((1+h):end, :); %y_{t+h}, t=1,...,T-h
    Y = YY(1:(end-h), :); %Y_t      t=1,...,T-h
    X = XX(1:(end-h), :); %X_t      t=1,...,T-h
   
  % Omit RHS regressor with zero variability (other than const) 
    varX = var(X);
    X(:,[varX(:,1:end-1) 1]<eps) = [];
    Z    = ZZ(1:(end-h), :); %z_t      t=1,...,T-h

  % Just-Identified IV
    IVcoeffs     =          ([X';Z']*[X,Y])\([X';Z']*y);
    OLScoeffs    =          ([X';Y']*[X,Y])\([X';Y']*y);
    u            = Y-[X,Z] *(([X';Z']*[X,Z])\([X';Z']*Y));   
    e            = y-[X,Y] * IVcoeffs;
    
    IRFs(1+h,:)     =   IVcoeffs(end,:);  
    IRFs_ols(1+h,:) =  OLScoeffs(end,:);
  
  % Some Additional Statistics for Later Use
    XXp    = (X'*X)./(LPIV.T-h);
    ZXp    = (Z'*X)./(LPIV.T-h);
    A      = [ -ZXp/XXp, 1 , zeros(1,size(XXp,1)), 0 ; ...
                zeros(1,size(XXp,1))   , 0 , -ZXp/XXp,1];
   
    M      =  eye((LPIV.T-h))-X*((X'*X)\X');
    ZMZp   = (Z'*M*Z/(LPIV.T-h));
    Zu     =  Z.*u;
    Xu     =  X.*kron(u,ones(1,size(X,2)));      % adj for older ML version
 
    for n = 1:LPIV.n
      Xe    =  X.*kron(e(:,n),ones(1,size(X,2)));
      W     = ((LPIV.T-h)/((LPIV.T-h)-LPIV.k)) ... 
              * NW_hac_STATA([Xe,Z.*e(:,n),Xu,Zu],LPIV.NWlags);
      LPIV.OmegaSTATA(:,:,n,1+h) = A*W*A'./(ZMZp^2);
    end
    LPIV.gamma1(1+h,:) = ZMZp\(Z'*M*Y./(LPIV.T-h));
  end

  scale          =  1;
  LPIV.irs       =  scale*IRFs;
  LPIV.irs_ols   =  scale*IRFs_ols;




