function IRF = myIRFs(AL,G,VAR)

% A. Obtain IRF(0)
  if VAR.k==1
     LC  =  chol(cov(VAR.res),'lower');
     A0  =  inv(LC');
     Q   =  [];
     Xd  =  randn(VAR.n); 
     
     if isempty(G)
       G = VAR.m' * VAR.res; 
     end
     
     Xj  =  Xd(:,1);
     Rj  =  null(G*A0)';               
     Nj  =  null(Rj);
     Q   =  Nj*Nj'*Xj/norm(Nj'*Xj);
     
     if  G*A0*Q <= 0
         Q  = -Q;
     end
     DT  =  inv(A0)'*Q;  
      
  else  error('k > 1 is not implemented')
  end

% B. Obtain IRF(h)  
  irs = zeros(VAR.p+VAR.irhor,VAR.n,size(DT,2));
  for jj = 1:size(DT,3)
      irs(VAR.p+1,:,jj) = DT(:,jj);
      for tt = 2:VAR.irhor
          lvars              = (irs(VAR.p+tt-1:-1:tt,:,jj))';
          irs(VAR.p+tt,:,jj) = lvars(:)'*AL(:,1:VAR.p*VAR.n)';     
      end
  end
  IRF = irs(VAR.p+1:end,:,:); 
  
% C. Accumulate for iC = 1
  if isfield(VAR,'iC')
     iC  =  logical(VAR.iC);
     LC_ =  nan(size(IRF));
  
     LC_(1,:)  = IRF(1,:);
     for h = 2:size(IRF,1)
         LC_(h,:) = LC_(h-1,:) + IRF(h,:);
     end  
     IRF(:,iC)   = LC_(:,iC);  
  end
  
% D. Form linear trafo of IR according to iR
  if isfield(VAR,'iR')
     IRF = IRF * VAR.iR'; 
  end
  
  
 