%__________________________________________________________________________
% ESTIMATE MERTENS - MONTIEL OLEA PROXY VAR WITH BOOTSTRAP   
%__________________________________________________________________________
% This uses an adaptation of the code by Mertens & Montiel Olea (QJE, 2018)
% to obtain standardised impulse responses
%
% Note that IRFs are accumulated and transformed in function myIRF 
% according to SPEC.iC and SPEC.iR
%__________________________________________________________________________
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir));
  
 [A,B]   =  xlsread([cDir 'Data\Data'],'All');
  DateQ  =  A(:,1:2);
  X      =  A(:,3:end);
  Names  =  B(:,3:end);
  
%__________________________________________________________________________
% DEFINE THE MODEL
%__________________________________________________________________________
  T1 = [1956  3];  
  T2 = [2016  12];             
 
  B_list  =  [1 2 5];                  % Bootstrap type (see myProxySVARci)
  p       =   4;                       % Nr of lags
  irf_H   =   80;                      % Length of IRFs reported
  
%__________________________________________________________________________
% PREPARE DATA
%__________________________________________________________________________  
% Find time range 
  iT     =  DateFind(DateQ,T1):DateFind(DateQ,T2);
  DateQ  =  DateQ(iT,:);
  T      =  size(DateQ,1);
   
% Generate VAR series
  dLX              =  log(X) - lagmatrix(log(X),1); 
  y                =  nan(T,7); 
  y(:,[3 4])       =    X(iT,[3 4]) / 100;  
  y(:,[1 2 5 6 7]) =  dLX(iT,[1 2 5 6 7]);
  yName            =  Names(1:7);                       

% Generate exogenous series  
  W      =   ones(T,1);
  wName  =   {'c'};
      
% Generate proxies
  z       =  X(iT,9:10);
  serZ    =  Names(9:10);

  
%__________________________________________________________________________
% CONVERT TO MERTENS AND MONTIEL SPECIFICATION AND RUN 
%__________________________________________________________________________
 for Z_IX  = 1:size(z,2)
 for B_IX  = B_list                        
     
   rng('default');
 
   SPEC.vars       =  y;
   SPEC.DET        =  W;
   SPEC.taxshocks  =  z(:,Z_IX);
   SPEC.p          =  p;
   SPEC.NWlags     =  8;   
   
   SPEC.irhor      =  irf_H;
   SPEC.iC         =  [1 1 0 0 1 1 1];             % = 1 -> accum IRF
   SPEC.iR         =  eye(7);                      % IRF(h,j) -> IRF * iR'
   SPEC.iR(7,2)    =  1;    
   clevel          =  [95 68]; 
   
   SVARIV          =  SPEC;
   SVARIV          =  myProxySVAR(SVARIV); 
   SVARIVci        =  myProxySVARci(SVARIV,clevel,B_IX,5000);
 
 % Save  
   fn = ['R_pV_Z' num2str(Z_IX) '_B' num2str(B_IX)];
   save([cDir 'Results_pV\' fn], ... 
        'DateQ','y','W','z','SVARIV','SVARIVci','yName','wName','T1','T2')
   
   disp(' ')
   disp([fn ' saved'])
   disp(' ')
 end  
 end
