% within_transform: within-transform panel data matrix
% X needs to be N*T by p
function [xWithinTransformed] = within_transform(xMatrix,N)
    [NT,p] = size(xMatrix);
    T = NT/N;
    xArray = reshape(xMatrix,N,[],p);
    xWithinTransformed = xMatrix - repmat(reshape(mean(xArray,2),N,p),T,1);
end