% simulate_panelmultibreak: Loop over sims, estimates and saves output
function [break_numbEst_Store,breakvecEst_Store,betaPlsEstimatorStore,...
	betaSfeEstimatorStore,betaFfeEstimatorStore,varBetaPlsEstimatorStore,...
	varBetaSfeEstimatorStore,varBetaFfeEstimatorStore,beta0,...
    WaldTestStoreSfe,WaldTestStoreFfe,m_hat,m_hat_beta,atleast1chi2_rej,aStore]...
	= simulate_panelmultibreak(N,T,p,sims,simScen,se_type,breakvector,beta0,timevarReg_ind,penaltytype,w_tcons,lasso)

break_numbEst_Store = NaN(sims,1);
if isnan(breakvector); break_truenumb = 0;
else; [break_truenumb,~] = size(breakvector);
end
dim = (break_truenumb+1)*p; 
if (simScen == 12||simScen==13); dim = 2*p; end
breakvecEst_Store        = NaN(sims,break_truenumb+3);
betaPlsEstimatorStore    = NaN(sims,dim);
betaSfeEstimatorStore    = NaN(sims,dim);
betaFfeEstimatorStore    = NaN(sims,dim);
varBetaPlsEstimatorStore = NaN(sims,dim);
varBetaSfeEstimatorStore = NaN(sims,dim);
varBetaFfeEstimatorStore = NaN(sims,dim);
WaldTestStoreSfe         = NaN(sims,dim*2);
WaldTestStoreFfe         = NaN(sims,dim*2);
m_hat                    = zeros(sims,3);
m_hat_beta               = zeros(sims,6);
atleast1chi2_rej         = zeros(sims,4);
aStore                   = NaN(sims,2);


for s = 1 : sims
    
%%% Simulate panel data with breaks %%%
if     simScen==6;  [y,xMatrix,xArray]     = datagen_panelmultibreak_forlasso(N,T,p,breakvector,beta0,w_tcons);
elseif simScen==12; [y,xArray,xMatrix,~,~] = datagen_panelmultibreak(N,T,p,breakvector,beta0,floor(T/3)); % break in c_it at floor(T/3)
else;               [y,xArray,xMatrix,~,~] = datagen_panelmultibreak(N,T,p,breakvector,beta0,NaN);        % no break in c_it
end

%%% Estimate break points %%%
if simScen == 6         
    if lasso == 0
        breakvecEst = est_numbbreaks_pls(y,xMatrix,N,T,penaltytype)';
    % elseif (lasso == 1);   % This option is not available in the package uploaded onto JAE data archive as it depends on the AFGL code by Qian & Su 2015
    %     % Transform data for group lasso estimator
    %     y_forlasso = reshape(reshape(y,N,T)',N*T,1);
    %     xMatrix_forlasso = zeros(N*T,p);
    %     for j = 1 : p
    %         xMatrix_forlasso(:,j) = reshape(xArray(:,:,j)',N*T,1);
    %     end
    %     option.maxLambda = 100; option.minLambda = 0.01; option.nGrid = 40;
    %     [regime,alpha,se,~,~,~,~] = panelpls(y_forlasso,xMatrix_forlasso,N,option);
    %     [regSize,~] = size(regime);
    %     if (regSize == 2); breakvecEst = NaN;
    %     else;              breakvecEst = regime(2:regSize-1,1) - ones(regSize-2,1);
    %     end
    end
else; breakvecEst = est_numbbreaks_pls(y,xMatrix,N,T,penaltytype)';
end

if ( (simScen == 12 || simScen == 13 || simScen == 14) && length(breakvecEst) > 2 )
    disp("Estimated number of breaks > 2");
    breakvecEst = breakvecEst(1:2);
end

% Save estimated break point vector
if isnan(breakvecEst) 
    break_numbEst = 0;
    breakvecEst_Store(s,:) = NaN(1,break_truenumb+3);
else
    [break_numbEst,~] = size(breakvecEst);
    if     (break_numbEst == break_truenumb); breakvecEst_Store(s,:) = [breakvecEst',NaN(1,3)];
    elseif (break_numbEst >  break_truenumb); breakvecEst_Store(s,1:break_numbEst) = breakvecEst(1:break_numbEst,1)';
    else;                                     breakvecEst_Store(s,:) = [breakvecEst',zeros(1,break_truenumb+3-break_numbEst)];
    end
end

% Store Estimation results for simulation s
break_numbEst_Store(s,1) = break_numbEst;

%%%%% Estimate beta with PLS, FE and FFE %%%%%
if (simScen == 1||simScen == 6||simScen == 12||simScen == 13||simScen == 14)
    % Estimate beta with PLS (inconsistent under endogeneity)
    if isnan(breakvecEst); betaPlsEstimator = regress(y,xMatrix);
    else;                  betaPlsEstimator = regress(y,diagonal_partition_multi(xMatrix,N,T,breakvecEst));
    end

    % Estimate beta with FE and FFE
    [betaSfeEstimator,betaFfeEstimator,varBetaSfeEstimator, ...
      CovBetaSfeEstimator,varBetaFfeEstimator,CovBetaFfeEstimator]...
        = est_beta_panelmultibreak(y,xArray,xMatrix,breakvecEst,timevarReg_ind,se_type);

    % Store Estimated results for simulation s
    betaPlsEstimatorStore(s,1:length(betaPlsEstimator))       = betaPlsEstimator';
    betaSfeEstimatorStore(s,1:length(betaSfeEstimator))       = betaSfeEstimator';
    betaFfeEstimatorStore(s,1:length(betaFfeEstimator))       = betaFfeEstimator'; 
    varBetaSfeEstimatorStore(s,1:length(varBetaSfeEstimator)) = varBetaSfeEstimator';
    varBetaFfeEstimatorStore(s,1:length(varBetaFfeEstimator)) = varBetaFfeEstimator';
    if (simScen == 6 && lasso == 1)
        betaPlsEstimatorStore(s,1:length(betaPlsEstimator))    = alpha';
        varBetaPlsEstimatorStore(s,1:length(betaPlsEstimator)) = se';
    end

    if (simScen == 12||simScen == 13||simScen == 14)
        if (break_numbEst==1||break_numbEst==2)
        % W-Test; restriction vector: beta_1 = beta_2 
        % (only implemented for case of one covariate and one break)            
            for FFE_ind = 0 : 1 % 1: FFE estimates; 0: FE estimates
                if     FFE_ind == 1 % FFE estimates
                    beta_hat       = betaFfeEstimator';
                    beta_hat_covar = CovBetaFfeEstimator;
                elseif FFE_ind == 0 % FE estimates
                    beta_hat       = betaSfeEstimator';
                    beta_hat_covar = CovBetaSfeEstimator;
                end
                if     (break_numbEst==1||break_numbEst==2)                 
                    W = (beta_hat(1,1) - beta_hat(1,2))^2 / (beta_hat_covar(1,1) + beta_hat_covar(2,2));
                    ind_reject = 0;
                    if     W > chi2inv(0.95,1); ind_reject = 1;
                    end
                    if     (FFE_ind == 1); WaldTestStoreFfe(s,1:2) = [W,ind_reject];
                    elseif (FFE_ind == 0); WaldTestStoreSfe(s,1:2) = [W,ind_reject];
                    end
                end
                if (break_numbEst==2)
                    W = [ W, (beta_hat(1,2) - beta_hat(1,3))^2 / (beta_hat_covar(2,2) + beta_hat_covar(3,3) - 2*beta_hat_covar(2,3))];
                    ind_reject = [ind_reject,0];
                    if     W(1,2) > chi2inv(0.95,1); ind_reject(1,2) = 1;
                    end
                    if     (FFE_ind == 1); WaldTestStoreFfe(s,3:4) = [W(1,2),ind_reject(1,2)];
                    elseif (FFE_ind == 0); WaldTestStoreSfe(s,3:4) = [W(1,2),ind_reject(1,2)];
                    end
                end
            end
        end
    % Indicators for estimated number of breaks, and simulations with break in betas
    if     (break_numbEst==2)
        m_hat(s,3) = 1;
        if     (WaldTestStoreSfe(s,2)+WaldTestStoreSfe(s,4) == 2); m_hat_beta(s,3) = 1; atleast1chi2_rej(s,2) = 1;
        elseif (WaldTestStoreSfe(s,2)+WaldTestStoreSfe(s,4) == 1); m_hat_beta(s,2) = 1; atleast1chi2_rej(s,2) = 1;
        end
        if     (WaldTestStoreFfe(s,2)+WaldTestStoreFfe(s,4) == 2); m_hat_beta(s,6) = 1; atleast1chi2_rej(s,4) = 1;
        elseif (WaldTestStoreFfe(s,2)+WaldTestStoreFfe(s,4) == 1); m_hat_beta(s,5) = 1; atleast1chi2_rej(s,4) = 1;
        end
    elseif (break_numbEst==1) 
        m_hat(s,2) = 1;
        if     (WaldTestStoreSfe(s,2) == 1); m_hat_beta(s,2) = 1; atleast1chi2_rej(s,1) = 1; end
        if     (WaldTestStoreFfe(s,2) == 1); m_hat_beta(s,5) = 1; atleast1chi2_rej(s,3) = 1; end
    elseif (break_numbEst==0); m_hat(s,1) = 1;
    elseif (break_numbEst >2); error('Error: break routine if break_numbEst > 2');
    end    
    m_hat_beta(s,1) = 1 - m_hat_beta(s,2) - m_hat_beta(s,3);
    m_hat_beta(s,4) = 1 - m_hat_beta(s,5) - m_hat_beta(s,6);

    % Compute Wald test for a_1 = a_2 with a_j = Q_j(gamma_j - beta_j) (no change across segments)
    if (simScen == 12 && length(betaFfeEstimator) == 2 && breakvecEst ~= 1 && breakvecEst ~= T-1)
        xPartitioned = diagonal_partition_multi(xMatrix,N,T,breakvecEst);
        c_hat = y - xPartitioned * betaSfeEstimator;
        xSubSampleDemeaned = [ within_transform(xMatrix(1:N*breakvecEst,:),N); ...
                               within_transform(xMatrix(N*breakvecEst+1:N*T,:),N)  ];
        ySubSampleDemeaned = [ within_transform(y(1:N*breakvecEst,:),N); ...
                               within_transform(y(N*breakvecEst+1:N*T,:),N)  ];
        epsilon_hat = ySubSampleDemeaned - diagonal_partition_multi(xSubSampleDemeaned,N,T,breakvecEst) * betaFfeEstimator;
        xc_temp = xMatrix .* c_hat;
        a_hat1  = mean(xc_temp(1 : N*breakvecEst));
        a_hat2  = mean(xc_temp(N*breakvecEst+1 : N*T));
        epsilon2_hat = epsilon_hat.^2;
        sigma2_hat1 = breakvecEst     / (breakvecEst - 1)   * mean(epsilon2_hat(1 : N*breakvecEst));
        sigma2_hat2 = (T-breakvecEst) / (T-breakvecEst - 1) * mean(epsilon2_hat(N*breakvecEst+1 : N*T));
        xMatrix2 = xMatrix.^2;
        Q_hat1  = mean(xMatrix2(1 : N*breakvecEst));
        Q_hat2  = mean(xMatrix2(N*breakvecEst+1 : N*T));
        Omega_hat1 = Q_hat1 - mean(   reshape(xArray(:,1:breakvecEst)',breakvecEst,1,N) ...
                                   .* permute(reshape(xArray(:,1:breakvecEst)',breakvecEst,1,N),[2 1 3]) ,'all');
        Omega_hat2 = Q_hat2 - mean(   reshape(xArray(:,breakvecEst+1:T)',T-breakvecEst,1,N) ...
                                   .* permute(reshape(xArray(:,breakvecEst+1:T)',T-breakvecEst,1,N),[2 1 3]) ,'all');
        c_hatArray = reshape(c_hat,N,T);      
        var_a1_hat = mean(   reshape(xArray(:,1:breakvecEst)'.*c_hatArray(:,1:breakvecEst)',breakvecEst,1,N) ...
                          .* permute(reshape(xArray(:,1:breakvecEst)'.*c_hatArray(:,1:breakvecEst)',breakvecEst,1,N),[2 1 3]) ,'all') ...
                          + sigma2_hat1*(breakvecEst  )^(-1)*(Q_hat1^2 * Omega_hat1^(-1) - 2*Q_hat1);  % - a_hat1^2
        var_a2_hat = mean(   reshape(xArray(:,breakvecEst+1:T)'.*c_hatArray(:,breakvecEst+1:T)',T-breakvecEst,1,N) ...
                          .* permute(reshape(xArray(:,breakvecEst+1:T)'.*c_hatArray(:,breakvecEst+1:T)',T-breakvecEst,1,N),[2 1 3]) ,'all') ...
                          + sigma2_hat2*(T-breakvecEst)^(-1)*(Q_hat2^2 * Omega_hat2^(-1) - 2*Q_hat2);  % - a_hat2^2  
        cov_a1_a2 = mean(   reshape(xArray(:,1:breakvecEst)'.*c_hatArray(:,1:breakvecEst)',breakvecEst,1,N) ...
                         .* permute(reshape(xArray(:,breakvecEst+1:T)'.*c_hatArray(:,breakvecEst+1:T)',T-breakvecEst,1,N),[2 1 3]) ,'all') ; % - a_hat1*a_hat2
        chi2_a1_a2 = N^(1/2)*(a_hat1 - a_hat2)^2 / (var_a1_hat + var_a2_hat - 2*cov_a1_a2); 
        aStore(s,1) = chi2_a1_a2;
        if (chi2_a1_a2 > chi2inv(0.95,1)); aStore(s,2) = 1;
        else; aStore(s,2) = 0;
        end

    end

    end
end

end % end loop over sims

end
