% diagonal_partition_multi.m -> diagonally partition the panel data matrix
% xMatrix (NT x p) over several breakpoints stored in the vector: breakpointvector.
% N: # Cross section units; T = # Time periods; p: # covariates.

function [xPartitioned_multi] = diagonal_partition_multi(xMatrix,N,T,breakvector)
[nt,p]=size(xMatrix);
[break_number,~] = size(breakvector);
xPartitioned_multi = zeros(nt,(break_number+1)*p);
xPartitioned_multi(1:N*breakvector(1,1),1:p) = xMatrix(1:N*breakvector(1,1),:);
if break_number > 1
    for i = 2 : break_number
       xPartitioned_multi(N*breakvector(i-1,1)+1:N*breakvector(i,1),(i-1)*p+1:i*p) ...
           = xMatrix(N*breakvector(i-1,1)+1:N*breakvector(i,1),:);
    end
end
xPartitioned_multi(N*breakvector(break_number,1)+1:nt,break_number*p+1:(break_number+1)*p) ...
    = xMatrix(N*breakvector(break_number,1)+1:nt,:);
end



