% datagen_panelmultibreak: generates data from a panel data model with 
% structural breaks given in breakvector
% breakvector: vector with locations of break points
% p: # parameters in beta0
% breaklocation_c: location of single break in c_i (breaklocation_c = NaN: constant c_i)
function [y,xArray,xMatrix,xPartitioned_multi,c] = datagen_panelmultibreak(N,T,p,breakvector,beta0,breaklocation_c)
    if isnan(breakvector); break_number = 0;
    else;                  [break_number,~] = size(breakvector);
    end 
    % DGP: y_it = x_it'beta0 + c_i + epsilon_it
    %      c_i, epsilon_it ~ N(0,1/4)
    %      x_it = sqrt(2)c_i + z_it, z_it ~ N(1/2)
	stdDevC = 0.5; 
	stdDevEpsilon = 0.5; 
	c = randn(N,1)*stdDevC; % set to c = zeros(N,1) to shut down FE (=> no endogeneity bias)
	% For breaklocation_c != NaN: c_i = s*c_i after breaklocation_c
    s = 1.5;
    % Generate x from c: x_it = sqrt(2)c_i + z_it
    exog_reg = zeros(N*T,p-1);
    if     (p == 1)
        if (isnan(breaklocation_c)); xMatrix = repmat(c,T,1)/stdDevC/sqrt(2) + randn(N*T,1)/sqrt(2);
        else; xMatrix = [repmat(c,breaklocation_c,1);repmat(s*c,T-breaklocation_c,1)] /stdDevC/sqrt(2) + randn(N*T,1)/sqrt(2);
        end
    elseif (p > 1)
        for j = 1 : p-1
            % Every third regressor generated is time-constant (Simscen 5)
            if     rem(j,3) ~= 0; exog_reg(:,j) = randn(N*T,1)/sqrt(2);                  % time-varying regressor
            elseif rem(j,3) == 0; g = randn(N,1); exog_reg(:,j) = repmat(g,T,1)/sqrt(2); % time-constant regressor
            end
        end
        xMatrix = [ ones(N*T,1) , repmat(c,T,p-1)/stdDevC/sqrt(2) + exog_reg ];
    end
    xArray = reshape(xMatrix,N,T,p);
	if     break_number > 0;  xPartitioned_multi = diagonal_partition_multi(xMatrix,N,T,breakvector);
    elseif break_number == 0; xPartitioned_multi = xMatrix;
    end
    if isnan(breaklocation_c); y = xPartitioned_multi*beta0 + repmat(c,T,1) + randn(N*T,1)*stdDevEpsilon;
    else; y = xPartitioned_multi*beta0 + [repmat(c,breaklocation_c,1);repmat(s*c,T-breaklocation_c,1)] + randn(N*T,1)*stdDevEpsilon;
    end
end


