
% Second Application: U.S. house price expectations after the financial crisis

clear 

% Import data
import_csvdata_hexp; % import hexp.csv


% Wave and Person identifier
wave = waveid;
waveid = [wave, id];

% Determine number of persons and time periods
[nt,~] = size(he1y);
N = 0;
for i = 1 : nt
    if wave(i,1) == 1
        N = N + 1;
    else; break
    end
end
N
T = nt/N


% Choose assumptions for Standard Errors (all assume number of breaks = 1)
% simScen = 0 % default (assume epsilon_it - epsilon_bar_it|X is iid)
simScen = 0.3; % 0.3 0.2 0.1
% 0.3: Case A (autocorrelation-  , conditional heteroskedasticity-robust)
% 0.2: Case B (No autocorrelation, conditional heteroskedasticity-robust)
% 0.1: Case C (No autocorrelation, conditional homoskedasticity)

% Define dependent variables he1y he5y
y = he1y;  % Pr(H1>100): What is percentage chance that home value increases by next year?


%tabulate(hg1_nsa)
%tabulate(urngq)
urngq = urngq*100;

% Regressor matrix as used in Niu & van Soest (2015), except for
% variable: 'disabled', 'unemploy', 'retired'
varNames_timevar =  {'constant', 'urngq', 'hg1_nsa', 'lhv', 'logfamilyincomePC', ... 
                     'householdsize', 'married',  ...               % 'unemploy', 'retired',
                     'health', 'genSent', 'ecoSent'};
varNames_timecons = {'age', 'sand', 'female', 'white1', 'schooling'};
% Variable name list for output table
varNames_all =      {'constant',' ','urngq',' ','hg1_nsa',' ','lhv',' ','logfamilyincomePC',' ',...
                     'householdsize',' ','married',' ' ...                   % 'unemploy',' ' ,'retired',' '
                     'health',' ','genSent',' ','ecoSent',' ','age',' ','sand',' ','female',' ','white1',' ','schooling',' '};
% Set row labels (use empty string for no label):
varNames_outtable = {'Constant',' ','Change in unemployment',' ','Change in house prices',' ','Log home value',' ','Log income per capita',' ',... % 'Change in unemployment',' ',
                     'Household size',' ','Married',' ',...      % 'Unemployed',' ','Retired',' ',
                     'Health',' ','Non-Eco Sentiment',' ','Eco Sentiment',' ','Age',' ','Sand',' ','Female',' ','White',' ','Schooling',' '};

timevarReg_ind = (2:length(varNames_timevar))';
regressorlist = [varNames_timevar(2:length(varNames_timevar)), varNames_timecons];

% Compute xMatrix
xMatrix =  ones(N*T,1); 
for var = regressorlist % loop over regressors list
    eval(sprintf('xMatrix = [xMatrix, %1$s];', var{1}));
end

% he1y		: Pr(H1>100)
% hg1_nsa	: (3 month) change in state house price index 
% urngq     : (3 month) change in state unemployment rate
% logfamilyincomePC : Log income per capita 
% householdsize: Household size
% schooling : Bachelor
% married
% unemploy	: Indicator unemployed
% retired	
% disabled
% health	: Ordinal scale 1 - 5
% genSent	: Non-Eco Sentiment
% ecoSent	: Eco Sentiment 
% lhv		: log home value
% sand 		: Sand states
% age
% female
% white


[~,p] = size(xMatrix);
xArray = reshape(xMatrix,N,T,p);

% Estimate number of breakpoints
penaltytype = 2; % 1: BIC-type log(NT)/NT; 2: log(log(NT))/NT
breakvecEst = est_numbbreaks_pls(y,xMatrix,N,T,penaltytype)'

% Estimate model with no break (standard FE) for compariason in output table
breakvecEst_temp = NaN;
[ betaSfeEstimator,~,varBetaSfeEstimator,...
  CovBetaSfeEstimator,~,CovBetaFfeEstimator ]...
    = est_beta_panelmultibreak(y,xArray,xMatrix,breakvecEst_temp,timevarReg_ind,simScen);
estoutMatrix_standardFE = [betaSfeEstimator,sqrt(varBetaSfeEstimator)];

% Estimate Beta coefficients
if isnan(breakvecEst) % Special case of no breaks
    break_numb = 0;
    [betaSfeEstimator,betaIvEstimator,betaFfeEstimator,...
     varBetaSfeEstimator,varBetaIvEstimator,varBetaFfeEstimator]...
        = est_beta_panelmultibreak(y,xArray,xMatrix,breakvecEst,timevarReg_ind,simScen);
    disp('----- FE Estimator over full sample -----');
    disp(' ');
    timewindow = ['Time: 0 - ',num2str(T)];
    segments = {'coeff','sd'};
    varNames = varNames_timevar(1+1:length(varNames_timevar));
    r=[{'---'},segments;varNames.',num2cell([betaSfeEstimator,sqrt(varBetaSfeEstimator)])];
    disp(r);
else % Case of at least one break: Estimate coefficients with SFE and FFE
    [betaSfeEstimator,betaFfeEstimator,varBetaSfeEstimator,...
     CovBetaSfeEstimator,varBetaFfeEstimator,CovBetaFfeEstimator]...
        = est_beta_panelmultibreak(y,xArray,xMatrix,breakvecEst,timevarReg_ind,simScen);
    [pTimevar,~] = size(timevarReg_ind);
    [break_numb,~] = size(breakvecEst);
    
    %disp('----- FE Estimator by Break Segments -----')
    %disp(' ')
    SFEbetaEst_Matrix  = reshape(betaSfeEstimator,[pTimevar,break_numb+1]);
    SEbetaSfeEstimator = reshape(sqrt(varBetaSfeEstimator),[pTimevar,break_numb+1]);
    segments = {'coeff','sd'};  
    estoutMatrix_FE = [SFEbetaEst_Matrix(:,1),SEbetaSfeEstimator(:,1)];
    for j = 2 : break_numb + 1
        if j < break_numb + 2 
            segments     = [ segments, {'coeff' ,'sd'} ];  
            estoutMatrix_FE = [ estoutMatrix_FE, [SFEbetaEst_Matrix(:,j),SEbetaSfeEstimator(:,j)] ];
        end
    end
    varNames = varNames_timevar(2:length(varNames_timevar));
    %r=[{'---'},segments;varNames.',num2cell(estoutMatrix_FE)];
    %disp(r);
        
    %fprintf('----- FFE Estimator by Break Segments (first row: intercepts) -----')
    %disp(' '); disp(' ');
    FFEbetaEst_Matrix  = reshape(betaFfeEstimator(1:(break_numb+1)*p),[p,break_numb+1]);
    SEbetaFfeEstimator = reshape(sqrt(varBetaFfeEstimator(1:(break_numb+1)*p)),[p,break_numb+1]);
    segments = {'coeff','sd'};  
    varNames = [varNames_timevar(1:length(varNames_timevar)), varNames_timecons]; 
    estoutMatrix_FFE = [FFEbetaEst_Matrix(:,1),SEbetaFfeEstimator(:,1)];
    for j = 2 : break_numb + 1
        segments     = [ segments, {'coeff','sd'} ];
        estoutMatrix_FFE = [ estoutMatrix_FFE, [FFEbetaEst_Matrix(:,j),SEbetaFfeEstimator(:,j)] ];
    end
    %out = [{'---'},segments;varNames.',num2cell(estoutMatrix_FFE)];
    %disp(out);
end

% Wald Test; restriction vector: beta_q = beta_l (joint test)
Wald_test_allseg_FFE = [];
Wald_test_allseg_FE = [];
for FFE_ind = 0 : 1  % 1: FFE estimates; 0: FE estimates
for q = 1 : length(breakvecEst) % loop over all pairs beta_q+1 - beta_q
    l = q+1;
    if     FFE_ind == 1 
        beta_hat       = FFEbetaEst_Matrix;
        beta_hat_covar = CovBetaFfeEstimator;
    elseif FFE_ind == 0 
        beta_hat       = SFEbetaEst_Matrix;
        beta_hat_covar = CovBetaSfeEstimator;
    end
    k    = min(sum(~isnan(beta_hat(:,q))), sum(~isnan(beta_hat(:,l))));
    kmax = max(sum(~isnan(beta_hat(:,q))), sum(~isnan(beta_hat(:,l))));
    r_beta = beta_hat(1+kmax-k:end,l) - beta_hat(1+kmax-k:end,q);
    R_beta = [ diag(ones(k,1)), (-1)*diag(ones(k,1)) ];
    if     FFE_ind == 1
        if     q == 1 
            Var_beta = [ [nan(1,kmax*2); [nan(k,1), beta_hat_covar(1:k,1:k), nan(k,kmax-k-1), beta_hat_covar(1:k,k+1:k+kmax)]]; ...
                         nan(kmax-k-1,2*kmax); ...
                         [nan(kmax,1), beta_hat_covar(k+1:k+kmax,1:k), nan(kmax,kmax-k-1), beta_hat_covar(k+1:k+kmax,k+1:k+kmax)] ];
        R_beta = [ [ zeros(1,kmax); zeros(kmax-1,1), [(-1)*diag(ones(k,1)), zeros(k,kmax-k-1); zeros(kmax-k-1,kmax-1)] ], diag(ones(kmax,1)) ];
        beta_hat_vec = [beta_hat(1:kmax,1); beta_hat(1:kmax,2)];
        beta_hat_vec(isnan(beta_hat_vec))=0;
        Var_beta(isnan(Var_beta))=0;
        r_beta = R_beta * beta_hat_vec;
        elseif q > 1; error('Error: q > 1');
        end
    elseif FFE_ind == 0; Var_beta = beta_hat_covar(1+(q-1)*k:(q-1)*k+2*k,1+(q-1)*k:(q-1)*k+2*k);
    end
    W = r_beta'*((R_beta*Var_beta*R_beta')^(-1))*r_beta;
    if     W > chi2inv(0.99,length(r_beta)); W = {[num2str(W,'%.3f') '***']};
    elseif W > chi2inv(0.95,length(r_beta)); W = {[num2str(W,'%.3f') '**']};
    elseif W > chi2inv(0.90,length(r_beta)); W = {[num2str(W,'%.3f') '*']};
    else;                                    W = {[num2str(W,'%.3f') '']};
    end
    if     FFE_ind == 1; Wald_test_allseg_FFE = [Wald_test_allseg_FFE ; W];
    elseif FFE_ind == 0; Wald_test_allseg_FE  = [Wald_test_allseg_FE ; W];
    end
end
end
if     length(breakvecEst) == 1; rowNames = {'beta_2 - beta_1'}';
elseif length(breakvecEst) == 2; rowNames = {'beta_2 - beta_1','beta_3 - beta_2'}';
elseif length(breakvecEst) == 3; rowNames = {'beta_2 - beta_1','beta_3 - beta_2','beta_4 - beta_3'}';
elseif length(breakvecEst) == 4; rowNames = {'beta_2 - beta_1','beta_3 - beta_2','beta_4 - beta_3','beta_4 - beta_3'}';
end
disp(' '); fprintf('Wald Test FE (joint test of all coefficients)');
[rowNames,Wald_test_allseg_FE]
disp(' '); fprintf('Wald Test FFE (joint test of all coefficients)');
[rowNames,Wald_test_allseg_FFE]

disp(' '); fprintf('Critical values Chi2 distribution')
[ 0.90, chi2inv(0.90,length(r_beta)); 0.95, chi2inv(0.95,length(r_beta)); 0.99, chi2inv(0.99,length(r_beta)) ]


% Add significance stars to columns with beta estimates
[~,estout_colnumb] = size(estoutMatrix_FE);
estoutSum = [];
for m = 0 : 2
if     m == 0 
    estoutMatrix_temp = [NaN(1,2);estoutMatrix_standardFE;NaN(5,2)];
    [estout_rownumb,estout_colnumb] = size(estoutMatrix_temp);
elseif m == 1 
    [estout_rownumb,estout_colnumb] = size(estoutMatrix_FFE);
    estoutMatrix_temp = estoutMatrix_FFE;
elseif m == 2 
    estoutMatrix_temp = [estoutMatrix_FE;NaN(length(varNames_timecons),estout_colnumb)];
    estoutMatrix_temp = [NaN(1,estout_colnumb);estoutMatrix_temp];
    [estout_rownumb,estout_colnumb] = size(estoutMatrix_temp);
end
estoutMatrix = cell(2*estout_rownumb,estout_colnumb/2);
q = 0;
for i = 1 : 2 : estout_colnumb 
for j = 1 : 1 : estout_rownumb
    if abs(estoutMatrix_temp(j,i)/estoutMatrix_temp(j,i+1)) > norminv(0.99,0,1) 
        estoutMatrix(2*j-1,i-q) = {[num2str(estoutMatrix_temp(j,i),'%.3f') '***']};
        estoutMatrix(2*j  ,i-q) = {['(' num2str(estoutMatrix_temp(j,i+1),'%.3f') ')']};
    elseif abs(estoutMatrix_temp(j,i)/estoutMatrix_temp(j,i+1)) > norminv(0.95,0,1)
        estoutMatrix(2*j-1,i-q) = {[num2str(estoutMatrix_temp(j,i),'%.3f') '**']};
        estoutMatrix(2*j  ,i-q) = {['(' num2str(estoutMatrix_temp(j,i+1),'%.3f') ')']};
    elseif abs(estoutMatrix_temp(j,i)/estoutMatrix_temp(j,i+1)) > norminv(0.90,0,1)
        estoutMatrix(2*j-1,i-q) = {[num2str(estoutMatrix_temp(j,i),'%.3f') '*']};
        estoutMatrix(2*j  ,i-q) = {['(' num2str(estoutMatrix_temp(j,i+1),'%.3f') ')']};
    else 
        estoutMatrix(2*j-1,i-q) = {num2str(estoutMatrix_temp(j,i),'%.3f')};
        estoutMatrix(2*j  ,i-q) = {['(' num2str(estoutMatrix_temp(j,i+1),'%.3f') ')']};
    end
end
q = q + 1;
end
estoutSum = [estoutSum, estoutMatrix];
end

disp('----- FFE and FE Estimator (first row: intercepts) -----');
disp(' ')
ColLabels2 = {};
for j = 1:1: estout_colnumb/2 
    ColLabels2 = [ColLabels2, {['Beta' num2str(j)]}];   
end
ColLabels2 = [ColLabels2,ColLabels2];
if     estout_colnumb/2 == 6; ColLabels1 = {'+----','----+','----+','FFE','----+','----+','+----','----+','FE','----+','----+','----+'};  
elseif estout_colnumb/2 == 5; ColLabels1 = {'+----','----+','FFE','----+','----+','+----','----+','FE','----+','----+'};  
elseif estout_colnumb/2 == 4; ColLabels1 = {'+----','FFE','----+','----+','+----','FE','----+','----+'};  
elseif estout_colnumb/2 == 3; ColLabels1 = {'+----','FFE','----+','+----','FE','----+'};  
elseif estout_colnumb/2 == 2; ColLabels1 = {'+--FFE','--+','+--FE','--+'}; 
elseif estout_colnumb/2 == 1; ColLabels1 = {'FFE','FE'}; 
end
ColLabels2 = ['Beta', ColLabels2];
ColLabels1 = ['Standard FE', ColLabels1];
r=[{'---'},ColLabels2; varNames_all.',estoutSum];
disp(r);


% Test if estimated slope coefficients are significantly different across segments (Assume: 1 break)
table_out  = varNames_outtable';
input.tableRowLabels = table_out;
for EstType = 1:2 %EstType = 1: FFE; 2: FE
    ptvar = length(timevarReg_ind);
    if EstType == 1 
        betaEstimator    = betaFfeEstimator; 
        varBetaEstimator = varBetaFfeEstimator;
        CovBetaEstimator = CovBetaFfeEstimator;
        pfull = p;
        betadiff    = betaEstimator(pfull+1:2*pfull,1) - [zeros(1,1);betaEstimator(2:ptvar+1,1);zeros(5,1)];
        betadiff_se = sqrt( varBetaEstimator(pfull+1:2*pfull,1) + [zeros(1,1);varBetaEstimator(2:1+ptvar,1);zeros(5,1)] ...
                            - [zeros(1,1);2*diag(CovBetaEstimator(ptvar+1+1:2*ptvar+1,1:ptvar));zeros(5,1)] );
        t_test = betadiff ./ betadiff_se;
    else 
        betaEstimator    = betaSfeEstimator;
        varBetaEstimator = varBetaSfeEstimator;
        CovBetaEstimator = CovBetaSfeEstimator;
        pfull = ptvar;
        betadiff    = betaEstimator(pfull+1:pfull+ptvar,1) - betaEstimator(1:ptvar,1);
        betadiff_se = sqrt(varBetaEstimator(pfull+1:pfull+ptvar,1) + varBetaEstimator(1:ptvar,1) ...
                         - 2*diag(CovBetaEstimator(pfull+1:pfull+ptvar,1:ptvar))                  );
        t_test = betadiff ./ betadiff_se;
    end
    signif = {};
    for j = 1 : pfull 
        if     abs(t_test(j)) > norminv(0.99,0,1); signif = [ signif , {[num2str(t_test(j),'%.3f') '***']}];
        elseif abs(t_test(j)) > norminv(0.95,0,1); signif = [ signif , {[num2str(t_test(j),'%.3f') '**' ]}];
        elseif abs(t_test(j)) > norminv(0.9 ,0,1); signif = [ signif , {[num2str(t_test(j),'%.3f') '*' ]}];
        else;                                      signif = [ signif , {[num2str(t_test(j),'%.3f') ' ' ]}];
        end
    end
    diff = {};
    for j = 1 : pfull 
        if     abs(t_test(j)) > norminv(0.99,0,1); diff = [ diff , {[num2str(betadiff(j),'%.3f') '***']}, {['(' num2str(betadiff_se(j),'%.3f') ')']} ];
        elseif abs(t_test(j)) > norminv(0.95,0,1); diff = [ diff , {[num2str(betadiff(j),'%.3f') '**' ]}, {['(' num2str(betadiff_se(j),'%.3f') ')']} ];
        elseif abs(t_test(j)) > norminv(0.9 ,0,1); diff = [ diff , {[num2str(betadiff(j),'%.3f') '*' ]}, {['(' num2str(betadiff_se(j),'%.3f') ')']} ];
        else;                                      diff = [ diff , {[num2str(betadiff(j),'%.3f') ' ' ]}, {['(' num2str(betadiff_se(j),'%.3f') ')']} ];
        end
    end
    if EstType == 2 
        temp = [{'NaN'};{'(NaN)'}];
        diff = [temp; diff';temp;temp;temp;temp;temp]';
    end
    table_out  = [table_out  , diff'];
end
disp('----- T-test of H0: beta2 - beta1 = 0 (FFE and FE) -----');
disp(' ')
disp([{'---','FFE','FE'} ; table_out])


% Combine Results before generating Latex table
nbreaks = length(breakvecEst);
table_combresults = [ [ estoutSum(:,1:nbreaks+1), ['-';' ';estoutSum(3:20,nbreaks+1+1);'-';' ';'-';' ';'-';' ';'-';' ';'-';' '], ...
                        table_out(:,2:nbreaks+1), estoutSum(:,nbreaks+3:2*nbreaks+3), table_out(:,nbreaks+2:2*nbreaks+1) ]; ...
                        [' ',' ',' ', Wald_test_allseg_FFE', ' ',' ', Wald_test_allseg_FE' ] ];
ColLabels2_combresults = [ ColLabels2(1:nbreaks+1+1),        {'Beta2-Beta1'}, ...
                           ColLabels2(nbreaks+3:2*nbreaks+3),{'Beta2-Beta1'}     ];
ColLabels1_combresults = [ ColLabels1(1:nbreaks+1+1),        {'---+'}, ...
                           ColLabels1(nbreaks+3:2*nbreaks+3),{'---+'}     ];
table_combresults = strrep(table_combresults,'(NaN)',' ');
table_combresults = strrep(table_combresults,'NaN','-');                
input.data = table_combresults;
outtable = [ ColLabels2_combresults; num2cell(input.data)];
RowLabels = ['-',varNames_all,'Wald Test'];
varNames_outtable = [varNames_outtable,'Wald Test'];
out = [{'---'},ColLabels1_combresults;RowLabels.',outtable];

% Export matlab matrix input.data to Latex table
input.tableColLabels = ColLabels1_combresults; %{'Bias','Sd','MSE','Bias','Sd','MSE','Bias','Sd','MSE','Bias','Sd','MSE'};
input.tableRowLabels = varNames_outtable;
input.transposeTable = 0;
input.dataFormatMode = 'column'; % use 'column' or 'row'. if not set 'colum' is used
input.dataFormat = {'%.3f'}; % %4.2f in the formatSpec input specifies 
input.dataNanString = '-';
input.tableColumnAlignment = 'c';
input.tableBorders = 0;
if     estout_colnumb/2 == 3; tableCap = ['FFE and FE estimates of slope coefficients; Breaks were estimated at ' num2str(breakvecEst(1,1)) ' and ' num2str(breakvecEst(2,1))];  
elseif estout_colnumb/2 == 2; tableCap = ['FFE and FE estimates of slope coefficients; Break was estimated at ' num2str(breakvecEst(1,1))];
elseif estout_colnumb/2 == 1; tableCap = 'FFE and FE estimates of slope coefficients; No break found';
end
input.tableCaption = tableCap;
input.tableLabel = 'MyTableLabel';
input.makeCompleteLatexDocument = 0;
latex = latexTable(input);








