
*APPENDIX ANALYSIS
set more off
cd X:\Data\Workdata\702092\marco\BO\zeroinc\restart2017\baseline\JAE_replication\200520\toJAE
capture log close
cls
log using appendix_analysis_2.txt, text replace

use data_replication_JAE, clear


*TABLE A1
preserve

bys family: gen sibs_in_sample = _N
gen sibs_sample = sibs_in_sample -1
replace sibs_sample = 3 if sibs_sample>3

gen sibs_school = sibs_by_school-1
replace sibs_school = 3 if sibs_school>3

ta sibs_sample sibs_school

restore

****************************
****************************

*TABLE A2

su wom mg order sibsize fspacing educp agem_birth agef_birth durb3 m_i_edp
su wom mg order sibsize fspacing educp agem_birth agef_birth durb3 m_i_edp if s_by_f_sample

su wom mg order sibsize fspacing educp agem_birth agef_birth durb3 m_i_edp if educp>0
su wom mg order sibsize fspacing educp agem_birth agef_birth durb3 m_i_edp if s_by_f_sample & educp>0

su wom mg order sibsize fspacing educp agem_birth agef_birth durb3 m_i_edp if educp<=0
su wom mg order sibsize fspacing educp agem_birth agef_birth durb3 m_i_edp if s_by_f_sample & educp<=0

****************************
****************************

*TABLE A3 a and b

preserve

keep if s_by_f_sample
global controls "wom i.order"
global add_controls "durb3 sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"


capture erase TabA3a.txt
capture erase TabA3a.xls

capture erase TabA3b.txt
capture erase TabA3b.xls

foreach y in yinc3I31 yinc3I33 yinc3I35 yinc3I37 yinc3I39 yinc3135 yinc3640 log3I31 log3I33 log3I35 log3I37 log3I39 logPI_3135 logPI_3640{

	global vars "m_i_edp"
	qui reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	outreg2 $vars using TabA3a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	global vars "m_i_edp educp_m_i_edp"
	noi reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA3b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

}

capture erase TabA3a.txt
capture erase TabA3b.txt

restore

****************************
****************************

*TABLE A4 a and b

capture erase TabA4a.txt
capture erase TabA4a.xls

capture erase TabA4b.txt
capture erase TabA4b.xls

foreach y in logPI yemp {
	preserve

	keep if s_by_f_sample
	global controls "wom i.order"
	global add_controls "durb3 sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"
	global vars "m_i_edp"

	sort s_by_f yob
	by s_by_f : ge n = _n
	by s_by_f : ge N = _N
	ta N
	by s_by_f: gen older_m_i_edp = m_i_edp[_n-1] if n==2
	by s_by_f: replace older_m_i_edp = (m_i_edp[_n-1]+m_i_edp[_n-2])/2 if n==3
	by s_by_f: replace older_m_i_edp = (m_i_edp[_n-1]+m_i_edp[_n-2]+m_i_edp[_n-3])/3 if n==4
	by s_by_f: replace older_m_i_edp = (m_i_edp[_n-1]+m_i_edp[_n-2]+m_i_edp[_n-3]+m_i_edp[_n-4])/4 if n==5
	by s_by_f: replace older_m_i_edp = (m_i_edp[_n-1]+m_i_edp[_n-2]+m_i_edp[_n-3]+m_i_edp[_n-4]+m_i_edp[_n-5])/5 if n==6
	br s_by_f yob m_i_edp older_m_i_edp educp n N

	*2+
	distinct s_by_f
	count

	qui reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	qui outreg2 $vars using TabA4a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, no, trends, by school) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars educp_m_i_edp $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA4b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school) addstat(mean outcome, `mean')

	*3+
	keep if N>2
	distinct s_by_f
	count

	noi reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp
	noi reghdfe
	outreg2 $vars using TabA4a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars educp_m_i_edp $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA4b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school) addstat(mean outcome, `mean')

	*3+ laterborns
	keep if N>2 & n>1
	distinct s_by_f
	count

	noi reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp
	noi reghdfe
	outreg2 $vars using TabA4a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars educp_m_i_edp $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA4b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars older_m_i_edp $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA4a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars educp_m_i_edp older_m_i_edp $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA4b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school) addstat(mean outcome, `mean')

	restore

}



capture erase TabA4a.txt
capture erase TabA4b.txt

****************************
****************************

*TABLE A5

preserve
keep if s_by_f_sample
global controls "wom i.order"
global add_controls "durb3 sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"
global vars "m_i_edp educp_m_i_edp"
capture erase TabA5.txt
capture erase TabA5.xls
foreach y in ed_tert hipaytert STEMtert {

	qui reghdfe `y' $vars , absorb(s_by_f yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	qui outreg2 $vars using TabA5.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, no, trends, homog, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls    $add_controls, absorb(s_by_f yob) vce(cluster school family)
	qui outreg2 $vars using TabA5.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, homog, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui outreg2 $vars using TabA5.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls if max_spacing<=5, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui outreg2 $vars using TabA5.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 5, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls if sibsize+1==sibs_by_school, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui outreg2 $vars using TabA5.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, same school) addstat(mean outcome, `mean')

}

capture erase TabA5.txt
restore

****************************
****************************

*TABLE A6 a and b
preserve
keep if s_by_f_sample
global controls "wom i.order"
global add_controls "durb3 sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"
global vars "m_i_edp m_i_edp_wom"

capture erase TabA6a.txt
capture erase TabA6a.xls


foreach y in logPI yemp {

	qui reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	noi lincom m_i_edp+m_i_edp_wom
	local b = r(estimate)
	local s = r(se)
	local t = r(estimate)/r(se)
	outreg2 $vars using TabA6a.xls, excel append dec(3) nocons nor2 ctitle(`y') ///
	addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) ///
	addstat(mean outcome, `mean', lincom, `b' , sd, `s' , tstat, `t')

}

capture erase TabA6a.txt

capture erase TabA6b.txt
capture erase TabA6b.xls

global vars "m_i_edp educp_m_i_edp m_i_edp_wom educp_wom educp_m_i_edp_wom"

foreach y in logPI yemp {

	qui reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	lincom m_i_edp+m_i_edp_wom
	local mw = r(estimate)
	local sdmw = r(se)
	local tmw = r(estimate)/r(se)
	lincom educp_m_i_edp+educp_m_i_edp_wom
	local imw = r(estimate)
	local sdimw = r(se)
	local timw = r(estimate)/r(se)

	qui outreg2 $vars using TabA6b.xls, excel append dec(3) nocons nor2 ctitle(`y') ///
	addtext(base X, yes, add X, yes, trends, by school) ///
	addstat(mean outcome, `mean', main wom, `mw',sd main wom, `sdmw', tstat main wom, `tmw', ///
	inter wom, `imw', sd inter wom, `sdimw',tstat inter wom, `timw')

}

restore
capture erase TabA6b.txt

*clear


****************************
****************************

*TABLE A7 - Col 1A and 2A.
*Col 1B and 2B replicate Col 3 of Tab 4 and Tab 5.
preserve

global controls "wom i.order"
global add_controls "sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"
global i_controls "educp mg agem_birth agef_birth sibsize durb3"

capture erase TabA7.txt
capture erase TabA7.xls

foreach y in logPI yemp {

	global vars "m_i_edp"
	qui reghdfe `y' $vars $controls $add_controls $i_controls , absorb(yob school##c.yob) vce(cluster school)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	outreg2 $vars using TabA7.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, sample, full) addstat(mean outcome, `mean')
	global vars "m_i_edp educp_m_i_edp"
	noi reghdfe `y' $vars $controls $add_controls $i_controls , absorb(yob school##c.yob) vce(cluster school)
	outreg2 $vars using TabA7.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, sample, full) addstat(mean outcome, `mean')

}

capture erase TabA7.txt

restore

****************************
****************************

*TABLE A8 a and b

preserve

keep if s_by_f_sample
global controls "wom i.order"
global add_controls "durb3 sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"

global vars "m_i_edp"

capture erase TabA8a.txt
capture erase TabA8a.xls

foreach y in logPI_simple {

	qui reghdfe `y' $vars , absorb(s_by_f yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	qui outreg2 $vars using TabA8a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, no, trends, homog, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls  $add_controls, absorb(s_by_f yob) vce(cluster school family)
	outreg2 $vars using TabA8a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, homog, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA8a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls if max_spacing<=5, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA8a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 5, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls if sibsize+1==sibs_by_school, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA8a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, same school) addstat(mean outcome, `mean')

}

capture erase TabA8a.txt

capture erase TabA8b.txt
capture erase TabA8b.xls

global vars "m_i_edp educp_m_i_edp"

foreach y in logPI_simple {

	qui reghdfe `y' $vars , absorb(s_by_f yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	qui outreg2 $vars using TabA8b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, no, trends, homog, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls  $add_controls, absorb(s_by_f yob) vce(cluster school family)
	outreg2 $vars using TabA8b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, homog, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA8b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls if max_spacing<=5, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA8b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 5, sibs, all) addstat(mean outcome, `mean')

	noi reghdfe `y' $vars $controls $add_controls if sibsize+1==sibs_by_school, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	outreg2 $vars using TabA8b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, same school) addstat(mean outcome, `mean')

}

capture erase TabA8b.txt
restore


****************************
****************************

*TABLE A9

preserve

keep if s_by_f_sample
global controls "pm_i_edp wom i.order"
global add_controls "durb3 sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"

global vars "m_i_edp"

capture erase TabA9a.txt
capture erase TabA9a.xls

foreach y in logPI yemp {

	qui reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	outreg2 $vars using TabA9a.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

}

capture erase TabA9a.txt

capture erase TabA9b.txt
capture erase TabA9b.xls

global vars "m_i_edp educp_m_i_edp"

foreach y in logPI yemp {

	qui reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)
	qui ge temp = e(sample)
	qui summ `y' if temp
	qui local mean = r(mean)
	qui drop temp

	noi reghdfe
	outreg2 $vars using TabA9b.xls, excel append dec(3) nocons nor2 ctitle(`y') addtext(base X, yes, add X, yes, trends, by school, Max spacing, 17, sibs, all) addstat(mean outcome, `mean')

}

capture erase TabA9b.txt
restore


****************************
****************************

*TABLE A10
preserve
bys wom: sum ed_tert logPI yemp
bys mg: sum ed_tert logPI yemp
ge privileged = educp>0
bys privileged: sum ed_tert logPI yemp
ge disadv = 1-priv

foreach i in logPI yemp {

	reg `i' wom
	reg `i' mg
	reg `i' disadv

}
restore

****************************
****************************

*FIGURE A1

foreach y in ed_tert hipaytert STEMtert  {

	use data_replication_JAE, clear
	keep if s_by_f_sample
	global controls "wom i.order"
	global add_controls "durb3 sg_s enr_s m_i_agemb m_i_agef m_i_sibsize m_i_durb3 m_i_ibo1 m_i_ibo2 m_i_ibo3 m_i_ibo4 m_i_mg"
	global vars "m_i_edp educp_m_i_edp"

	noi reghdfe `y' $vars $controls $add_controls, absorb(s_by_f school#c.yob yob) vce(cluster school family)

	foreach x in m_i_edp{
		dis "graph `x' and educp"
		local count = 0
		qui forvalues i = -2(0.2)2{
			local count = `count' +1
			lincom (_b[`x']+(`i')*(_b[educp_`x']))
			scalar `y'_`x'_mb`count' = r(estimate)
			scalar `y'_`x'_mse`count' = r(se)
		}
		clear
		set obs 21
		gen mb = .
		gen mse = .
		gen m_i_edp = .
		local count = 0
		ge nobs = _n
		qui forvalues i = -2(0.2)2{
			local count = `count' +1
			replace m_i_edp = `i' if nobs == `count'
			replace mb = `y'_`x'_mb`count' if nobs == `count'
			replace mse = `y'_`x'_mse`count' if nobs == `count'
		}
		ge lo_mb = mb-1.96*mse
		ge hi_mb = mb+1.96*mse
		sort m_i_edp
		twoway (scatter mb m_i_edp, mcolor(black) connect(l) lpattern(solid) lwidth(thin) lcolor(black) msymbol(D) msize(small)) ///
			   (scatter lo_mb m_i_edp, mcolor(black) connect(l) lpattern(dash) lwidth(thin) lcolor(black) msymbol(none) msize(small)) ///
			   (scatter hi_mb m_i_edp, mcolor(black) connect(l) lpattern(dash) lwidth(thin) lcolor(black) msymbol(none) msize(small)) , yline(0, lcolor(black)) ///
			   graphregion(fcolor(white)) legend(off) ytitle("Marginal effect of E(PE)") xtitle("PE") saving(FigA1_`y'.gph, replace)
	}
}


clear

log close
