%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [irp, irn, irfpup, irfpdown, irfnup, irfndown, ...
    irpneu, irnneu, irfpneuup, irfpneudown, irfnneuup, irfnneudown]= varsn_2s_fp(ucl,lcl,colsv,shock)

% fill the firpst rows with GDP specification and other variables
[irps, irns, irfpups, irfpdowns, irfnups, irfndowns, ...
    irpneus, irnneus, irfpneuups, irfpneudowns, irfnneuups, irfnneudowns]=varsn_2s(ucl,lcl,5,colsv,shock);
irp(1:7,:)=irps(1:7,:); irfpup(1:7,:)=irfpups(1:7,:); irfpdown(1:7,:)=irfpdowns(1:7,:);
irn(1:7,:)=irns(1:7,:); irfnup(1:7,:)=irfnups(1:7,:); irfndown(1:7,:)=irfndowns(1:7,:);
irpneu(1:7,:)=irpneus(1:7,:); irfpneuup(1:7,:)=irfpneuups(1:7,:); irfpneudown(1:7,:)=irfpneudowns(1:7,:);
irnneu(1:7,:)=irnneus(1:7,:); irfnneuup(1:7,:)=irfnneuups(1:7,:); irfnneudown(1:7,:)=irfnneudowns(1:7,:);

% Consumption
[irps, irns, irfpups, irfpdowns, irfnups, irfndowns, ...
    irpneus, irnneus, irfpneuups, irfpneudowns, irfnneuups, irfnneudowns]=varsn_2s(ucl,lcl,10,colsv,shock);
irp(8,:)=irps(2,:); irfpup(8,:)=irfpups(2,:); irfpdown(8,:)=irfpdowns(2,:);
irn(8,:)=irns(2,:); irfnup(8,:)=irfnups(2,:); irfndown(8,:)=irfndowns(2,:);
irpneu(8,:)=irpneus(2,:); irfpneuup(8,:)=irfpneuups(2,:); irfpneudown(8,:)=irfpneudowns(2,:);
irnneu(8,:)=irnneus(2,:); irfnneuup(8,:)=irfnneuups(2,:); irfnneudown(8,:)=irfnneudowns(2,:);

% Investment
[irps, irns, irfpups, irfpdowns, irfnups, irfndowns, ...
    irpneus, irnneus, irfpneuups, irfpneudowns, irfnneuups, irfnneudowns]=varsn_2s(ucl,lcl,11,colsv,shock);
irp(9,:)=irps(2,:); irfpup(9,:)=irfpups(2,:); irfpdown(9,:)=irfpdowns(2,:);
irn(9,:)=irns(2,:); irfnup(9,:)=irfnups(2,:); irfndown(9,:)=irfndowns(2,:);
irpneu(9,:)=irpneus(2,:); irfpneuup(9,:)=irfpneuups(2,:); irfpneudown(9,:)=irfpneudowns(2,:);
irnneu(9,:)=irnneus(2,:); irfnneuup(9,:)=irfnneuups(2,:); irfnneudown(9,:)=irfnneudowns(2,:);

% Saving Rate
[irps, irns, irfpups, irfpdowns, irfnups, irfndowns, ...
    irpneus, irnneus, irfpneuups, irfpneudowns, irfnneuups, irfnneudowns]=varsn_2s(ucl,lcl,12,colsv,shock);
irp(10,:)=irps(2,:); irfpup(10,:)=irfpups(2,:); irfpdown(10,:)=irfpdowns(2,:);
irn(10,:)=irns(2,:); irfnup(10,:)=irfnups(2,:); irfndown(10,:)=irfndowns(2,:);
irpneu(10,:)=irpneus(2,:); irfpneuup(10,:)=irfpneuups(2,:); irfpneudown(10,:)=irfpneudowns(2,:);
irnneu(10,:)=irnneus(2,:); irfnneuup(10,:)=irfnneuups(2,:); irfnneudown(10,:)=irfnneudowns(2,:);


end