%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ir, irfup, irfdown, irneu, irfneuup, irfneudown]= var_2s_fp(ucl,lcl,colsv,shock)

% fill the first rows with GDP specification and other variables
[irs, irfups, irfdowns, irneus, irfneuups, irfneudowns]=vvar_2s(ucl,lcl,5,colsv,shock);
ir(1:7,:)=irs(1:7,:); irfup(1:7,:)=irfups(1:7,:); irfdown(1:7,:)=irfdowns(1:7,:);
irneu(1:7,:)=irneus(1:7,:); irfneuup(1:7,:)=irfneuups(1:7,:); irfneudown(1:7,:)=irfneudowns(1:7,:);

% Consumption
[irs, irfups, irfdowns, irneus, irfneuups, irfneudowns]=vvar_2s(ucl,lcl,10,colsv,shock);
ir(8,:)=irs(2,:); irfup(8,:)=irfups(2,:); irfdown(8,:)=irfdowns(2,:);
irneu(8,:)=irneus(2,:); irfneuup(8,:)=irfneuups(2,:); irfneudown(8,:)=irfneudowns(2,:);

% Investment
[irs, irfups, irfdowns, irneus, irfneuups, irfneudowns]=vvar_2s(ucl,lcl,11,colsv,shock);
ir(9,:)=irs(2,:); irfup(9,:)=irfups(2,:); irfdown(9,:)=irfdowns(2,:);
irneu(9,:)=irneus(2,:); irfneuup(9,:)=irfneuups(2,:); irfneudown(9,:)=irfneudowns(2,:);

% Saving Rate
[irs, irfups, irfdowns, irneus, irfneuups, irfneudowns]=vvar_2s(ucl,lcl,12,colsv,shock);
ir(10,:)=irs(2,:); irfup(10,:)=irfups(2,:); irfdown(10,:)=irfdowns(2,:);
irneu(10,:)=irneus(2,:); irfneuup(10,:)=irfneuups(2,:); irfneudown(10,:)=irfneudowns(2,:);

end