%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_rsvcv_fp(ucl,lcl,colsv)


% fill the first rows with GDP specification and other variables
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs]=tvarsn_2s_rsvcv(ucl,lcl,5,colsv);
irp0(1:7,:)=irp0s(1:7,:); irp1(1:7,:)=irp1s(1:7,:); irn0(1:7,:)=irn0s(1:7,:); irn1(1:7,:)=irn1s(1:7,:);
irfp0up(1:7,:)=irfp0ups(1:7,:); irfp0down(1:7,:)=irfp0downs(1:7,:); irfp1up(1:7,:)=irfp1ups(1:7,:); irfp1down(1:7,:)=irfp1downs(1:7,:);
irfn0up(1:7,:)=irfn0ups(1:7,:); irfn0down(1:7,:)=irfn0downs(1:7,:); irfn1up(1:7,:)=irfn1ups(1:7,:); irfn1down(1:7,:)=irfn1downs(1:7,:);

% Consumption
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs]=tvarsn_2s_rsvcv(ucl,lcl,10,colsv);
irp0(8,:)=irp0s(2,:); irp1(8,:)=irp1s(2,:); irn0(8,:)=irn0s(2,:); irn1(8,:)=irn1s(2,:);
irfp0up(8,:)=irfp0ups(2,:); irfp0down(8,:)=irfp0downs(2,:); irfp1up(8,:)=irfp1ups(2,:); irfp1down(8,:)=irfp1downs(2,:);
irfn0up(8,:)=irfn0ups(2,:); irfn0down(8,:)=irfn0downs(2,:); irfn1up(8,:)=irfn1ups(2,:); irfn1down(8,:)=irfn1downs(2,:);

% Investment
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs]=tvarsn_2s_rsvcv(ucl,lcl,11,colsv);
irp0(9,:)=irp0s(2,:); irp1(9,:)=irp1s(2,:); irn0(9,:)=irn0s(2,:); irn1(9,:)=irn1s(2,:);
irfp0up(9,:)=irfp0ups(2,:); irfp0down(9,:)=irfp0downs(2,:); irfp1up(9,:)=irfp1ups(2,:); irfp1down(9,:)=irfp1downs(2,:);
irfn0up(9,:)=irfn0ups(2,:); irfn0down(9,:)=irfn0downs(2,:); irfn1up(9,:)=irfn1ups(2,:); irfn1down(9,:)=irfn1downs(2,:);

% Saving Rate
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs]=tvarsn_2s_rsvcv(ucl,lcl,12,colsv);
irp0(10,:)=irp0s(2,:); irp1(10,:)=irp1s(2,:); irn0(10,:)=irn0s(2,:); irn1(10,:)=irn1s(2,:);
irfp0up(10,:)=irfp0ups(2,:); irfp0down(10,:)=irfp0downs(2,:); irfp1up(10,:)=irfp1ups(2,:); irfp1down(10,:)=irfp1downs(2,:);
irfn0up(10,:)=irfn0ups(2,:); irfn0down(10,:)=irfn0downs(2,:); irfn1up(10,:)=irfn1ups(2,:); irfn1down(10,:)=irfn1downs(2,:);

end