%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, irfn0up, irfn0down, irfn1up, irfn1down]=tvarsn_2s_rsvcv(ucl,lcl,colm,colsv)

%% TVAR with Sign Nonlinearity - Iterated FGLS estimator
rng('default')
rng(1)

%% set preliminary parameters

p=2;        % number of lags in the VAR
irh=10;     % time horizon for the impulse responses
reps=10000;  % number of repetitions of the bootstrap
ucl=ucl;     % upper confidence level for IRFs
lcl=lcl;     % lower confidence level for IRFs
f=100;      % number of intervals for gird search
pl=30;      % lower percentile for grid search
pu=70;      % upper percentile for grid search
colm=colm;    % sets the macro variable of interest (pos 2 in the VAR)
colsv=colsv;   % sets the column of the switching variable

%% Import Data

data_macro_series % first set of macro variables (see m.file for the content)
data_proxy_series  % narrative shock variables (see m.file for the content)
data_switching_series  % uncertainty variables (see m.file for the content)

%% Generate the vector of Y's

dates0 = data_macro(:,1);

% Select or apply proper tranformation to the switching variable
if colsv==13 % residuals of jln's macro unc. on A&G business cycle proxy
    % [~, ~, Z0]=regress(data_SV(:,5),[ones(size(data_SV(:,5),1),1) data_SV(:,12)]);
    [~, ~, Z0]=regress(data_SV(:,5),[ones(size(data_SV(:,5),1),1),(data_macro(:,5)-lagmatrix(data_macro(:,5),1))]);
elseif colsv==11   % detrend epu
    [~, ~, Z0]=regress(data_SV(:,11),[ones(size(data_SV(:,11),1),1) (1:size(data_SV(:,11),1))']);
else
    Z0=data_SV(:,colsv);
end

% Build the matrix of endogenous variables: Cost of debt, GDP (or other macro variable), Inflation,
% Tax revenues, Government spending, Uncertainty variable, FFR
Y0=[data_macro(:,8) data_macro(:,colm)  data_macro(:,9) data_macro(:,7) data_macro(:,6) Z0 data_macro(:,13)];

% Smoothing of the threshold variable for the identification of regimes
if colsv~=12
    Z0=tsmovavg(Z0,'s',6,1);
end

% Build the vector of Romer and Romer narrative tax shocks
V0=data_proxy(:,6);
V0m=data_proxy(:,9); % RR monetary policy shocks

ngdp=data_macro(:,14);
rrabs=data_proxy(:,5);

% Find extremes of the estimation sample
extr=get_extremes([Y0 Z0 V0 V0m]);
s=max(extr(1,:));
e=min(extr(2,:));

Y0=Y0(s:e,:);
Z0=Z0(s:e,:);
V0=V0(s:e,:);
V0m=V0m(s:e,:);
dates0=dates0(s:e,:);
ngdp=ngdp(s:e,:);
rrabs=rrabs(s:e,:);

% Narrative shocks of different sign
Vs0=zeros(size(V0,1),2);
for j=1:size(V0,1)
    if V0(j)>0
        Vs0(j,1)=V0(j);
    elseif V0(j)<0
        Vs0(j,2)=V0(j);
    end
end


%% generate X's 

X0=[];
for j=1:p
    X0=[X0 lagmatrix(Y0,j)];
end

Y=Y0(p+1:end,:);
Z=Z0(p+1:end,:);
Vs=Vs0(p+1:end,:);
V=V0(p+1:end,:);
Vm=V0m(p+1:end,:);
X=X0(p+1:end,:);
dates=dates0(p+1:end,:);
ngdp=ngdp(p+1:end,:);
rrabs=rrabs(p+1:end,:);

T=size(Y,1);
N=size(Y,2);
X=[ones(T,1) X Vm Vs];

%% nonlinear model - estimation

betanlmat=zeros(N*p*2+8,N,f);
RSS=zeros(f,N);
grid=linspace(prctile(Z,pl),prctile(Z,pu),f);
bnlglsmat=zeros(2*(N*p+4),N,f);
resglsmat=zeros(T,N,f);
RSSgls=zeros(f,1);

for j=1:f
    
    % generate X's
    d=zeros(T,1);
    for jj=2:T
        d(jj)=Z(jj-1)>=grid(j);
    end
    Xnl=X;
    Xnl=[Xnl Xnl.*repmat(d,1,N*p+4)];
    
    % estimate parameters of the VAR
    betanlmat(:,:,j)=(Xnl'*Xnl)\(Xnl'*Y);
    betanl=(Xnl'*Xnl)\(Xnl'*Y);
    resnl=Y-Xnl*betanlmat(:,:,j);
    betanlpp=betanl;
    bbb=zeros(2*(N*p+1),N);
    
    % GLS
    yvec=Y(:);
    sig0=(resnl.*(ones(T,N)-repmat(d,1,N)))'*(resnl.*(ones(T,N)-repmat(d,1,N)))./(T-N+1);
    sig1=(resnl.*repmat(d,1,N))'*(resnl.*repmat(d,1,N))./(T-N+1);
    ZZ=kron(eye(N),Xnl);
    midblock=kron(inv(sig0),(ones(T,T)-repmat(d,1,T)).*(Xnl*inv(Xnl'*Xnl)*Xnl'))+ ...
        kron(inv(sig1),repmat(d,1,T).*(Xnl*inv(Xnl'*Xnl)*Xnl'));
    bestvec=(ZZ'*midblock*ZZ)\(ZZ'*midblock*yvec);
    
    bbb=reshape(bestvec,(N*p+4)*2,N);
    resnl=Y-Xnl*bbb;  
    
    bnlglsmat(:,:,j)=bbb;
    resglsmat(:,:,j)=resnl;    
    RSSgls(j)=sum(sum(resglsmat(:,:,j).^2));
end

% determine the threshold with the minimum RSS
posmin=find(RSSgls==min(RSSgls));
posmin=posmin(1);
thresh=grid(posmin);

d=zeros(T,1);
for jj=2:T
    d(jj)=Z(jj-1)>=thresh;
end
Xnl=X;
Xnl=[Xnl Xnl.*repmat(d,1,N*p+4)];
betanlpp=bnlglsmat(:,:,posmin);
resnlpp=resglsmat(:,:,posmin);
bbb=betanlmat(:,:,posmin);
betanlorig=bbb;



while abs(norm(betanlpp)-norm(bbb))>10e-6
    
    betanlpp=bbb;
    
    for j=1:f
        
    % generate X's
    d=zeros(T,1);
        for jj=2:T
            d(jj)=Z(jj-1)>=grid(j);
        end
    Xnl=X;
    Xnl=[Xnl Xnl.*repmat(d,1,N*p+4)];
    
    % GLS
    yvec=Y(:);
    sig0=(resnlpp.*(ones(T,N)-repmat(d,1,N)))'*(resnlpp.*(ones(T,N)-repmat(d,1,N)));
    sig1=(resnlpp.*repmat(d,1,N))'*(resnlpp.*repmat(d,1,N));
    ZZ=kron(eye(N),Xnl);
    midblock=kron(inv(sig0),(ones(T,T)-repmat(d,1,T)).*(Xnl*inv(Xnl'*Xnl)*Xnl'))+ ...
        kron(inv(sig1),repmat(d,1,T).*(Xnl*inv(Xnl'*Xnl)*Xnl'));
    bestvec=(ZZ'*midblock*ZZ)\(ZZ'*midblock*yvec);
    
    bbb=reshape(bestvec,(N*p+4)*2,N);
    resnlg=Y-Xnl*bbb;  
  
    bnlglsmat(:,:,j)=bbb;
    resglsmat(:,:,j)=resnlg;    
    RSSgls(j)=sum(sum(resglsmat(:,:,j).^2));
    
    end
    
    % determine the threshold with the minimum RSS
    posmin=find(RSSgls==min(RSSgls));
    posmin=posmin(1);
    thresh=grid(posmin);

    d=zeros(T,1);
    for jj=2:T
        d(jj)=Z(jj-1)>=thresh;
    end
    bbb=bnlglsmat(:,:,posmin);
    resnlpp=resglsmat(:,:,posmin);
    sig0=resnlpp(d==0,:)'*resnlpp(d==0,:);
    sig1=resnlpp(d==1,:)'*resnlpp(d==1,:);
    
end

betanl=bbb;
resnl=resnlpp;

% impulse responses
betanl0=betanl(1:N*p+4,:);
betanl1=betanl(1:N*p+4,:)+betanl(N*p+5:end,:);
Cf0=[betanl(2:N*p+1,:)'; eye(N*(p-1)) zeros(N*(p-1),N)];
Cf1=[betanl(2:N*p+1,:)'+betanl(N*p+6:end-3,:)'; eye(N*(p-1)) zeros(N*(p-1),N)];

% Tax increase - low uncertainty
irp0(:,1)=[betanl(N*p+3,:)'; zeros(N*(p-1),1)];
for j=2:irh
    irp0(:,j)=Cf0*irp0(:,j-1);
end

% tax cut - low uncertainty
irn0(:,1)=[betanl(N*p+4,:)'; zeros(N*(p-1),1)];
for j=2:irh
    irn0(:,j)=Cf0*irn0(:,j-1);
end

% tax increase - high uncertainty
irp1(:,1)=[betanl(N*p+3,:)'+betanl(end-1,:)'; zeros(N*(p-1),1)];
for j=2:irh
    irp1(:,j)=Cf1*irp1(:,j-1);
end

% tax cut - high uncertainty
irn1(:,1)=[betanl(N*p+4,:)'+betanl(end,:)'; zeros(N*(p-1),1)];
for j=2:irh
    irn1(:,j)=Cf1*irn1(:,j-1);
end

%% bootstrap for the nonlinear model

betanlmat=zeros((N*p+4)*2,N,reps);
irp0mat=zeros(N*p,irh,reps);
irn0mat=zeros(N*p,irh,reps);
irp1mat=zeros(N*p,irh,reps);
irn1mat=zeros(N*p,irh,reps);

for j=1:reps
    
    % generate new Y
    vv=randi([1,T],T,1);
    
    % first method
    Yb=Y+resnlpp(vv,:);
    for jj=p+1:T
        if d(jj)==0
            Yb(jj,:)=betanl0(1,:)+betanl0(end-1,:).*Vs(jj,1)+betanl0(end,:).*Vs(jj,2)+betanl0(end-2,:).*Vm(jj)+resnl(vv(jj),:);
            for hh=1:p
                Yb(jj,:)=Yb(jj,:)+Yb(jj-hh,:)*betanl0(N*(hh-1)+2:N*(hh-1)+N+1,:);
            end
        else
            Yb(jj,:)=betanl1(1,:)+betanl1(end-1,:).*Vs(jj,1)+betanl1(end,:).*Vs(jj,2)+betanl1(end-2,:).*Vm(jj)+resnl(vv(jj),:);
            for hh=1:p
                Yb(jj,:)=Yb(jj,:)+Yb(jj-hh,:)*betanl1(N*(hh-1)+2:N*(hh-1)+N+1,:);
            end
        end
    end
    
    % generate new X
    Xb=[];
    for jj=1:p
        Xb=[Xb lagmatrix(Yb,jj)];
    end
    for jj=1:p
        Xb(1:jj,N*(jj-1)+1:N*(jj-1)+N)=Y0(1:jj,:);
    end
    Xb=[ones(T,1) Xb Vm Vs];
    Xb=[Xb Xb.*repmat(d,1,N*p+4)];
    betanlmat(:,:,j)=(Xb'*Xb)\(Xb'*Yb);
    resnlb=Yb-Xb*betanlmat(:,:,j);
    
    % GLS
    bnlglsb=zeros(2*(N*p+4),N);
    betanlb=betanlmat(:,:,j);
    
    ybvec=Yb(:);
    sig0b=(resnlb.*(ones(T,N)-repmat(d,1,N)))'*(resnlb.*(ones(T,N)-repmat(d,1,N)));
    sig1b=(resnlb.*repmat(d,1,N))'*(resnlb.*repmat(d,1,N));
    ZZb=kron(eye(N),Xb);
    midblockb=kron(inv(sig0b),(ones(T,T)-repmat(d,1,T)).*(Xb*inv(Xb'*Xb)*Xb'))+ ...
        kron(inv(sig1b),repmat(d,1,T).*(Xb*inv(Xb'*Xb)*Xb'));
    bestvecb=(ZZb'*midblockb*ZZb)\(ZZb'*midblockb*ybvec);
    
    bnlglsb=reshape(bestvecb,(N*p+4)*2,N);
    resnlgb=Y-Xb*bnlglsb;  
    
    while abs(norm(bnlglsb)-norm(betanlb))>10e-6
    betanlb=bnlglsb;

    sig0b=(resnlgb.*(ones(T,N)-repmat(d,1,N)))'*(resnlgb.*(ones(T,N)-repmat(d,1,N)))./(T-N+1);
    sig1b=(resnlgb.*repmat(d,1,N))'*(resnlgb.*repmat(d,1,N))./(T-N+1);
    ZZb=kron(eye(N),Xb);
    midblockb=kron(inv(sig0b),(ones(T,T)-repmat(d,1,T)).*(Xb*inv(Xb'*Xb)*Xb'))+ ...
        kron(inv(sig1b),repmat(d,1,T).*(Xb*inv(Xb'*Xb)*Xb'));
    bestvecb=(ZZb'*midblockb*ZZb)\(ZZb'*midblockb*ybvec);
    
    bnlglsb=reshape(bestvecb,(N*p+4)*2,N);
    resnlgb=Y-Xb*bnlglsb;  

    end
    
    betanlmat(:,:,j)=bnlglsb;
    
    Cf0=[betanlmat(2:N*p+1,:,j)'; eye(N*(p-1)) zeros(N*(p-1),N)];
    Cf1=[betanlmat(2:N*p+1,:,j)'+betanlmat(N*p+6:end-3,:,j)'; eye(N*(p-1)) zeros(N*(p-1),N)];

    % tax increase - low uncertainty
    irp0mat(:,1,j)=[betanlmat(N*p+3,:,j)'; zeros(N*(p-1),1)];
    for jj=2:irh
        irp0mat(:,jj,j)=Cf0*irp0mat(:,jj-1,j);
    end
    
    % tax cut - low uncertainty
    irn0mat(:,1,j)=[betanlmat(N*p+4,:,j)'; zeros(N*(p-1),1)];
    for jj=2:irh
        irn0mat(:,jj,j)=Cf0*irn0mat(:,jj-1,j);
    end
    
    % tax increase - high uncertainty
    irp1mat(:,1,j)=[betanlmat(N*p+3,:,j)'+betanlmat(end-1,:,j)'; zeros(N*(p-1),1)];
    for jj=2:irh
        irp1mat(:,jj,j)=Cf1*irp1mat(:,jj-1,j);
    end
    
    % tax cut - high uncertainty
    irn1mat(:,1,j)=[betanlmat(N*p+4,:,j)'+betanlmat(end,:,j)'; zeros(N*(p-1),1)];
    for jj=2:irh
        irn1mat(:,jj,j)=Cf1*irn1mat(:,jj-1,j);
    end
    
end

irfp0up=prctile(irp0mat,ucl,3);
irfp0down=prctile(irp0mat,lcl,3);
irfn0up=prctile(irn0mat,ucl,3);
irfn0down=prctile(irn0mat,lcl,3);
irfp1up=prctile(irp1mat,ucl,3);
irfp1down=prctile(irp1mat,lcl,3);
irfn1up=prctile(irn1mat,ucl,3);
irfn1down=prctile(irn1mat,lcl,3);





