%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, irfn0up, irfn0down,...
    irfn1up, irfn1down, estdata, mult, thresh]=tvarsn_2s_girf(ucl,lcl,colm,colsv)

%% TVAR Sign Nonlinearity - GIRFs
rng('default')
rng(1)

%% set preliminary parameters

p=2;        % number of lags in the VAR
irh=10;     % time horizon for the impulse responses
reps=300;  % number of repetitions of the bootstrap
ucl=ucl;     % upper confidence level for IRFs
lcl=lcl;     % lower confidence level for IRFs
f=100;      % number of intervals for gird search
pl=30;      % lower percentile for grid search
pu=70;      % upper percentile for grid search
colm=colm;    % sets the macro variable of interest (pos 2 in the VAR)
colsv=colsv;   % sets the column of the switching variable

%% Import Data

data_macro_series % first set of macro variables (see m.file for the content)
data_proxy_series  % narrative shock variables (see m.file for the content)
data_switching_series  % uncertainty variables (see m.file for the content)

%% Generate the vector of Y's

dates0 = data_macro(:,1);

% Select or apply proper tranformation to the switching variable
if colsv==13 % residuals of jln's macro unc. on QoQ GDP growth
    % [~, ~, Z0]=regress(data_SV(:,5),[ones(size(data_SV(:,5),1),1) data_SV(:,12)]);
    [~, ~, Z0]=regress(data_SV(:,5),[ones(size(data_SV(:,5),1),1),(data_macro(:,5)-lagmatrix(data_macro(:,5),1))]);
elseif colsv==11   % detrend epu
    [~, ~, Z0]=regress(data_SV(:,11),[ones(size(data_SV(:,11),1),1) (1:size(data_SV(:,11),1))']);
else
    Z0=data_SV(:,colsv);
end

% Build the matrix of endogenous variables: Cost of debt, GDP (or other macro variable), Inflation,
% Tax revenues, Government spending, Uncertainty variable, FFR
Y0=[data_macro(:,8) data_macro(:,colm)  data_macro(:,9) data_macro(:,7) data_macro(:,6) Z0 data_macro(:,13)];

% Smoothing of the threshold variable for the identification of regimes
if colsv~=12
    Z0=tsmovavg(Z0,'s',6,1);
end

% Build the vector of Romer and Romer narrative tax shocks
V0=data_proxy(:,6);
V0m=data_proxy(:,9); % RR monetary policy shocks

ngdp=data_macro(:,14);
rrabs=data_proxy(:,5);

% Find extremes of the estimation sample
extr=get_extremes([Y0 Z0 V0 V0m]);
s=max(extr(1,:));
e=min(extr(2,:));

Y0=Y0(s:e,:);
Z0=Z0(s:e,:);
V0=V0(s:e,:);
V0m=V0m(s:e,:);
dates0=dates0(s:e,:);
ngdp=ngdp(s:e,:);
rrabs=rrabs(s:e,:);

% Narrative shocks of different sign
Vs0=zeros(size(V0,1),2);
for j=1:size(V0,1)
    if V0(j)>0
        Vs0(j,1)=V0(j);
    elseif V0(j)<0
        Vs0(j,2)=V0(j);
    end
end


%% generate X's 

X0=[];
for j=1:p
    X0=[X0 lagmatrix(Y0,j)];
end

Y=Y0(p+1:end,:);
Z=Z0(p+1:end,:);
Vs=Vs0(p+1:end,:);
V=V0(p+1:end,:);
Vm=V0m(p+1:end,:);
X=X0(p+1:end,:);
dates=dates0(p+1:end,:);
ngdp=ngdp(p+1:end,:);
rrabs=rrabs(p+1:end,:);

T=size(Y,1);
N=size(Y,2);
X=[ones(T,1) X Vm Vs];

%% Nonlinear model - estimation

betanlmat=zeros(N*p*2+8,N,f);
RSS=zeros(f,N);
grid=linspace(prctile(Z,pl),prctile(Z,pu),f);

for j=1:f
    
    % generate X's
    d=zeros(T,1);
    for jj=2:T
        d(jj)=Z(jj-1)>=grid(j);
    end
    Xnl=X;
    Xnl=[Xnl Xnl.*repmat(d,1,N*p+4)];
    
    % estimate parameters of the VAR
    betanlmat(:,:,j)=(Xnl'*Xnl)\(Xnl'*Y);
    resnl=Y-Xnl*betanlmat(:,:,j);
    RSS(j,:)=sum(resnl.^2);
    
end

% determine the threshold with the minimum RSS

posmin=find(sum(RSS,2)==min(sum(RSS,2)));
% posmin=find(sum(RSS(:,yp),2)==min(sum(RSS(:,yp),2)));
posmin=posmin(1);
thresh=grid(posmin);

d=zeros(T,1);
for jj=2:T
    d(jj)=Z(jj-1)>=thresh;
end
Xnl=X;
Xnl=[Xnl Xnl.*repmat(d,1,N*p+4)];
betanl=(Xnl'*Xnl)\(Xnl'*Y);
resnl=Y-Xnl*betanl;

estdata=[dates Y Z d Vm Vs];

% impulse responses
betanl0=betanl(1:N*p+4,:);
betanl1=betanl(1:N*p+4,:)+betanl(N*p+5:end,:);
Cf0=[betanl(2:N*p+1,:)'; eye(N*(p-1)) zeros(N*(p-1),N)];
Cf1=[betanl(2:N*p+1,:)'+betanl(N*p+6:end-3,:)'; eye(N*(p-1)) zeros(N*(p-1),N)];


%% GIRF 
B=200;
R=T-irh-p;
irp0matpe=nan(irh,N,B*R);
irn0matpe=nan(irh,N,B*R);
irp1matpe=nan(irh,N,B*R);
irn1matpe=nan(irh,N,B*R);

iterhr=0;
iterlr=0;

for tt=p+1:T-irh
    hist=Y(tt-p+1:tt,:);
    dpar=d(tt+1:tt+irh,:);
    
    for iii=1:B

        errh=randi([p+1,T-irh],1);
        errs=resnl(errh+1:errh+irh,:);
        irbase=[hist; nan(irh,size(Y,2))];
        irshockp=[hist; nan(irh,size(Y,2))];
        irshockn=[hist; nan(irh,size(Y,2))]; 
        
        if dpar(1)==0
            iterlr=iterlr+1;
        elseif dpar(1)==1
            iterhr=iterhr+1;
        end
        
        for jjj=1:irh
            
            if dpar(jjj)==0
                % base case
                irbase(jjj+p,:)=betanl0(1,:)+errs(jjj,:);
                for iiii=1:p
                    irbase(jjj+p,:)=irbase(jjj+p,:)+irbase(jjj+p-iiii,:)*betanl0((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                end
                
                % positive shock
                if jjj==1
                    irshockp(jjj+p,:)=betanl0(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl0((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                    irshockp(jjj+p,:)=irshockp(jjj+p,:)+betanl0(end-1,:);
                else
                    irshockp(jjj+p,:)=betanl0(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl0((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                end
                
                % negative shock
                if jjj==1
                    irshockn(jjj+p,:)=betanl0(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl0((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                    irshockn(jjj+p,:)=irshockn(jjj+p,:)-betanl0(end,:);
                else
                    irshockn(jjj+p,:)=betanl0(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl0((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                end
                    
            elseif dpar(jjj)==1
                
                % base case
                irbase(jjj+p,:)=betanl1(1,:)+errs(jjj,:);
                for iiii=1:p
                    irbase(jjj+p,:)=irbase(jjj+p,:)+irbase(jjj+p-iiii,:)*betanl1((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                end
                
                % positive shock
                if jjj==1
                    irshockp(jjj+p,:)=betanl1(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl1((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                    irshockp(jjj+p,:)=irshockp(jjj+p,:)+betanl1(end-1,:);
                else
                    irshockp(jjj+p,:)=betanl1(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl1((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                end
                
                % negative shock
                if jjj==1
                    irshockn(jjj+p,:)=betanl1(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl1((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                    irshockn(jjj+p,:)=irshockn(jjj+p,:)-betanl1(end,:);
                else
                    irshockn(jjj+p,:)=betanl1(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl1((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end
                end
            end
        end
        
        irpB=irshockp-irbase;
        irnB=irshockn-irbase;
        
        if dpar(1)==0
            irp0matpe(:,:,iterlr)=irpB(3:end,:);
            irn0matpe(:,:,iterlr)=irnB(3:end,:);
        elseif dpar(1)==1
            irp1matpe(:,:,iterhr)=irpB(3:end,:);
            irn1matpe(:,:,iterhr)=irnB(3:end,:);
        end
    end
end

irp0matpe(:,:,iterlr+1:R*B)=[];
irn0matpe(:,:,iterlr+1:R*B)=[];
irp1matpe(:,:,iterhr+1:R*B)=[];
irn1matpe(:,:,iterhr+1:R*B)=[];

irp0=mean(irp0matpe,3);
irp1=mean(irp1matpe,3);
irn0=mean(irn0matpe,3);
irn1=mean(irn1matpe,3);

%% GIRF bootstrap

betanlmat=zeros((N*p+4)*2,N,reps);
irp0mat=zeros(irh,N,reps);
irn0mat=zeros(irh,N,reps);
irp1mat=zeros(irh,N,reps);
irn1mat=zeros(irh,N,reps);

for j=1:reps
    j
    % generate new Y
    vv=randi([1,T],T,1);
    
    % first method
    Yb=Y+resnl(vv,:);
    for jj=p+1:T
        if d(jj)==0
            Yb(jj,:)=betanl0(1,:)+betanl0(end-1,:).*Vs(jj,1)+betanl0(end,:).*Vs(jj,2)+betanl0(end-2,:).*Vm(jj)+resnl(vv(jj),:);
            for hh=1:p
                Yb(jj,:)=Yb(jj,:)+Yb(jj-hh,:)*betanl0(N*(hh-1)+2:N*(hh-1)+N+1,:);
            end
        else
            Yb(jj,:)=betanl1(1,:)+betanl1(end-1,:).*Vs(jj,1)+betanl1(end,:).*Vs(jj,2)+betanl1(end-2,:).*Vm(jj)+resnl(vv(jj),:);
            for hh=1:p
                Yb(jj,:)=Yb(jj,:)+Yb(jj-hh,:)*betanl1(N*(hh-1)+2:N*(hh-1)+N+1,:);
            end
        end
    end
    
    % generate new X
    Xb=[];
    for jj=1:p
        Xb=[Xb lagmatrix(Yb,jj)];
    end
    for jj=1:p
        Xb(1:jj,N*(jj-1)+1:N*(jj-1)+N)=Y0(1:jj,:);
    end
    Xb=[ones(T,1) Xb Vm Vs];
    Xb=[Xb Xb.*repmat(d,1,N*p+4)];
    
    % compute estimated coefficients and CF matrix
    betanlmat(:,:,j)=(Xb'*Xb)\(Xb'*Yb);

    betanl0B=betanlmat(1:N*p+4,:,j);
    betanl1B=betanlmat(1:N*p+4,:,j)+betanlmat(N*p+5:end,:,j);
    resnlB=Yb-Xb*betanlmat(:,:,j);
    
    irp0matBpe=nan(irh,N,B*R);
    irn0matBpe=nan(irh,N,B*R);
    irp1matBpe=nan(irh,N,B*R);
    irn1matBpe=nan(irh,N,B*R);

    iterhr=0;
    iterlr=0;

    for tt=p+1:T-irh
        hist=Y(tt-p+1:tt,:);
        dpar=d(tt+1:tt+irh,:);

        for iii=1:B

            errh=randi([p+1,T-irh],1);
            errs=resnlB(errh+1:errh+irh,:);
            irbase=[hist; nan(irh,size(Y,2))];
            irshockp=[hist; nan(irh,size(Y,2))];
            irshockn=[hist; nan(irh,size(Y,2))]; 

            if dpar(1)==0
                iterlr=iterlr+1;
            elseif dpar(1)==1
                iterhr=iterhr+1;
            end

            for jjj=1:irh

                if dpar(jjj)==0
                    % base case
                    irbase(jjj+p,:)=betanl0B(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irbase(jjj+p,:)=irbase(jjj+p,:)+irbase(jjj+p-iiii,:)*betanl0B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end

                    % positive shock
                    if jjj==1
                        irshockp(jjj+p,:)=betanl0B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl0B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                        irshockp(jjj+p,:)=irshockp(jjj+p,:)+betanl0B(end-1,:);
                    else
                        irshockp(jjj+p,:)=betanl0B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl0B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                    end

                    % negative shock
                    if jjj==1
                        irshockn(jjj+p,:)=betanl0B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl0B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                        irshockn(jjj+p,:)=irshockn(jjj+p,:)-betanl0B(end,:);
                    else
                        irshockn(jjj+p,:)=betanl0B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl0B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                    end

                elseif dpar(jjj)==1

                    % base case
                    irbase(jjj+p,:)=betanl1B(1,:)+errs(jjj,:);
                    for iiii=1:p
                        irbase(jjj+p,:)=irbase(jjj+p,:)+irbase(jjj+p-iiii,:)*betanl1B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                    end

                    % positive shock
                    if jjj==1
                        irshockp(jjj+p,:)=betanl1B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl1B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                        irshockp(jjj+p,:)=irshockp(jjj+p,:)+betanl1B(end-1,:);
                    else
                        irshockp(jjj+p,:)=betanl1B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockp(jjj+p,:)=irshockp(jjj+p,:)+irshockp(jjj+p-iiii,:)*betanl1B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                    end

                    % negative shock
                    if jjj==1
                        irshockn(jjj+p,:)=betanl1B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl1B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                        irshockn(jjj+p,:)=irshockn(jjj+p,:)-betanl1B(end,:);
                    else
                        irshockn(jjj+p,:)=betanl1B(1,:)+errs(jjj,:);
                        for iiii=1:p
                            irshockn(jjj+p,:)=irshockn(jjj+p,:)+irshockn(jjj+p-iiii,:)*betanl1B((iiii-1)*size(Y,2)+1+1:(iiii-1)*size(Y,2)+1+size(Y,2),:);
                        end
                    end
                end
            end

            irpB=irshockp-irbase;
            irnB=irshockn-irbase;

            if dpar(1)==0
                irp0matBpe(:,:,iterlr)=irpB(3:end,:);
                irn0matBpe(:,:,iterlr)=irnB(3:end,:);
            elseif dpar(1)==1
                irp1matBpe(:,:,iterhr)=irpB(3:end,:);
                irn1matBpe(:,:,iterhr)=irnB(3:end,:);
            end
        end
    end

    irp0matBpe(:,:,iterlr+1:R*B)=[];
    irn0matBpe(:,:,iterlr+1:R*B)=[];
    irp1matBpe(:,:,iterhr+1:R*B)=[];
    irn1matBpe(:,:,iterhr+1:R*B)=[];

    irp0mat(:,:,j)=mean(irp0matBpe,3);
    irp1mat(:,:,j)=mean(irp1matBpe,3);
    irn0mat(:,:,j)=mean(irn0matBpe,3);
    irn1mat(:,:,j)=mean(irn1matBpe,3);    
    
end

irfp0up=prctile(irp0mat,ucl,3);
irfp0down=prctile(irp0mat,lcl,3);
irfn0up=prctile(irn0mat,ucl,3);
irfn0down=prctile(irn0mat,lcl,3);
irfp1up=prctile(irp1mat,ucl,3);
irfp1down=prctile(irp1mat,lcl,3);
irfn1up=prctile(irn1mat,ucl,3);
irfn1down=prctile(irn1mat,lcl,3);

irp0=irp0';
irp1=irp1';
irn0=irn0';
irn1=irn1';
irfp0up=irfp0up';
irfp0down=irfp0down';
irfp1up=irfp1up';
irfp1down=irfp1down';
irfn0up=irfn0up';
irfn0down=irfn0down';
irfn1up=irfn1up';
irfn1down=irfn1down';

%% Multipliers

% Define useful objects
dp0=(V>0 & d==0); % Identifier for observations with a positive shock and low-regime
dp1=(V>0 & d==1); % Identifier for observations with a positive shock and high-regime
dn0=(V>0 & d==0); % Identifier for observations with a negative shock and low-regime
dn1=(V>0 & d==1); % Identifier for observations with a negative shock and high-regime
hor=1;

clear mult2 bands2

[mult2(1), bands2(1,:)]=multiplier_m2(hor,irp0(2,:),squeeze(irp0mat(2,:,:))',ngdp(dp0==1),rrabs(dp0==1));
[mult2(2), bands2(2,:)]=multiplier_m2(hor,irp1(2,:),squeeze(irp1mat(2,:,:))',ngdp(dp1==1),rrabs(dp1==1));
[mult2(3), bands2(3,:)]=multiplier_m2(hor,irn0(2,:),squeeze(irn0mat(2,:,:))',ngdp(dn0==1),rrabs(dn0==1));
[mult2(4), bands2(4,:)]=multiplier_m2(hor,irn1(2,:),squeeze(irn1mat(2,:,:))',ngdp(dn1==1),rrabs(dn1==1));
mult=[mult2' bands2];

end