%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down, irp0neu, irp1neu, irn0neu, irn1neu, irfp0neuup, irfp0neudown, irfp1neuup, irfp1neudown, ...
    irfn0neuup, irfn0neudown, irfn1neuup, irfn1neudown] = tvarsn_2s_fp(ucl,lcl,colsv,shock)

% fill the first rows with GDP specification and other variables
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs, irp0neus,...
    irp1neus, irn0neus, irn1neus, irfp0neuups, irfp0neudowns, irfp1neuups, ...
    irfp1neudowns, irfn0neuups, irfn0neudowns, irfn1neuups, irfn1neudowns]=tvarsn_2shocks(ucl,lcl,5,colsv,shock);
irp0(1:7,:)=irp0s(1:7,:); irp1(1:7,:)=irp1s(1:7,:); irn0(1:7,:)=irn0s(1:7,:); irn1(1:7,:)=irn1s(1:7,:);
irfp0up(1:7,:)=irfp0ups(1:7,:); irfp0down(1:7,:)=irfp0downs(1:7,:); irfp1up(1:7,:)=irfp1ups(1:7,:); irfp1down(1:7,:)=irfp1downs(1:7,:);
irfn0up(1:7,:)=irfn0ups(1:7,:); irfn0down(1:7,:)=irfn0downs(1:7,:); irfn1up(1:7,:)=irfn1ups(1:7,:); irfn1down(1:7,:)=irfn1downs(1:7,:);
irp0neu(1:7,:)=irp0neus(1:7,:); irp1neu(1:7,:)=irp1neus(1:7,:); irn0neu(1:7,:)=irn0neus(1:7,:); irn1neu(1:7,:)=irn1neus(1:7,:);
irfp0neuup(1:7,:)=irfp0neuups(1:7,:); irfp0neudown(1:7,:)=irfp0neudowns(1:7,:); irfp1neuup(1:7,:)=irfp1neuups(1:7,:); irfp1neudown(1:7,:)=irfp1neudowns(1:7,:);
irfn0neuup(1:7,:)=irfn0neuups(1:7,:); irfn0neudown(1:7,:)=irfn0neudowns(1:7,:); irfn1neuup(1:7,:)=irfn1neuups(1:7,:); irfn1neudown(1:7,:)=irfn1neudowns(1:7,:);


% Consumption
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs, ...
    irp0neus, irp1neus, irn0neus, irn1neus, irfp0neuups, irfp0neudowns, irfp1neuups, ...
    irfp1neudowns, irfn0neuups, irfn0neudowns, irfn1neuups, irfn1neudowns]=tvarsn_2shocks(ucl,lcl,10,colsv,shock);
irp0(8,:)=irp0s(2,:); irp1(8,:)=irp1s(2,:); irn0(8,:)=irn0s(2,:); irn1(8,:)=irn1s(2,:);
irfp0up(8,:)=irfp0ups(2,:); irfp0down(8,:)=irfp0downs(2,:); irfp1up(8,:)=irfp1ups(2,:); irfp1down(8,:)=irfp1downs(2,:);
irfn0up(8,:)=irfn0ups(2,:); irfn0down(8,:)=irfn0downs(2,:); irfn1up(8,:)=irfn1ups(2,:); irfn1down(8,:)=irfn1downs(2,:);
irp0neu(8,:)=irp0neus(2,:); irp1neu(8,:)=irp1neus(2,:); irn0neu(8,:)=irn0neus(2,:); irn1neu(8,:)=irn1neus(2,:);
irfp0neuup(8,:)=irfp0neuups(2,:); irfp0neudown(8,:)=irfp0neudowns(2,:); irfp1neuup(8,:)=irfp1neuups(2,:); irfp1neudown(8,:)=irfp1neudowns(2,:);
irfn0neuup(8,:)=irfn0neuups(2,:); irfn0neudown(8,:)=irfn0neudowns(2,:); irfn1neuup(8,:)=irfn1neuups(2,:); irfn1neudown(8,:)=irfn1neudowns(2,:);


% Investment
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs,...
    irp0neus, irp1neus, irn0neus, irn1neus, irfp0neuups, irfp0neudowns, irfp1neuups, ...
    irfp1neudowns, irfn0neuups, irfn0neudowns, irfn1neuups, irfn1neudowns]=tvarsn_2shocks(ucl,lcl,11,colsv,shock);
irp0(9,:)=irp0s(2,:); irp1(9,:)=irp1s(2,:); irn0(9,:)=irn0s(2,:); irn1(9,:)=irn1s(2,:);
irfp0up(9,:)=irfp0ups(2,:); irfp0down(9,:)=irfp0downs(2,:); irfp1up(9,:)=irfp1ups(2,:); irfp1down(9,:)=irfp1downs(2,:);
irfn0up(9,:)=irfn0ups(2,:); irfn0down(9,:)=irfn0downs(2,:); irfn1up(9,:)=irfn1ups(2,:); irfn1down(9,:)=irfn1downs(2,:);
irp0neu(9,:)=irp0neus(2,:); irp1neu(9,:)=irp1neus(2,:); irn0neu(9,:)=irn0neus(2,:); irn1neu(9,:)=irn1neus(2,:);
irfp0neuup(9,:)=irfp0neuups(2,:); irfp0neudown(9,:)=irfp0neudowns(2,:); irfp1neuup(9,:)=irfp1neuups(2,:); irfp1neudown(9,:)=irfp1neudowns(2,:);
irfn0neuup(9,:)=irfn0neuups(2,:); irfn0neudown(9,:)=irfn0neudowns(2,:); irfn1neuup(9,:)=irfn1neuups(2,:); irfn1neudown(9,:)=irfn1neudowns(2,:);


% Saving Rate
[irp0s, irp1s, irn0s, irn1s, irfp0ups, irfp0downs, irfp1ups, ...
    irfp1downs, irfn0ups, irfn0downs, irfn1ups, irfn1downs, ...
    irp0neus, irp1neus, irn0neus, irn1neus, irfp0neuups, irfp0neudowns, irfp1neuups, ...
    irfp1neudowns, irfn0neuups, irfn0neudowns, irfn1neuups, irfn1neudowns]=tvarsn_2shocks(ucl,lcl,12,colsv,shock);
irp0(10,:)=irp0s(2,:); irp1(10,:)=irp1s(2,:); irn0(10,:)=irn0s(2,:); irn1(10,:)=irn1s(2,:);
irfp0up(10,:)=irfp0ups(2,:); irfp0down(10,:)=irfp0downs(2,:); irfp1up(10,:)=irfp1ups(2,:); irfp1down(10,:)=irfp1downs(2,:);
irfn0up(10,:)=irfn0ups(2,:); irfn0down(10,:)=irfn0downs(2,:); irfn1up(10,:)=irfn1ups(2,:); irfn1down(10,:)=irfn1downs(2,:);
irp0neu(10,:)=irp0neus(2,:); irp1neu(10,:)=irp1neus(2,:); irn0neu(10,:)=irn0neus(2,:); irn1neu(10,:)=irn1neus(2,:);
irfp0neuup(10,:)=irfp0neuups(2,:); irfp0neudown(10,:)=irfp0neudowns(2,:); irfp1neuup(10,:)=irfp1neuups(2,:); irfp1neudown(10,:)=irfp1neudowns(2,:);
irfn0neuup(10,:)=irfn0neuups(2,:); irfn0neudown(10,:)=irfn0neudowns(2,:); irfn1neuup(10,:)=irfn1neuups(2,:); irfn1neudown(10,:)=irfn1neudowns(2,:);

end