%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ir0, ir1, irf0up, irf0down, irf1up, irf1down, ...
    ir0neu, ir1neu, irf0neuup, irf0neudown, irf1neuup, irf1neudown]= tvar_2s_fp(ucl,lcl,colsv,shock)

% fill the first rows with GDP specification and other variables
[ir0s, ir1s, irf0ups, irf0downs, irf1ups, irf1downs, ...
    ir0neus, ir1neus, irf0neuups, irf0neudowns, irf1neuups, irf1neudowns]=tvar_2s(ucl,lcl,5,colsv,shock);
ir0(1:7,:)=ir0s(1:7,:); ir1(1:7,:)=ir1s(1:7,:); 
irf0up(1:7,:)=irf0ups(1:7,:); irf0down(1:7,:)=irf0downs(1:7,:); irf1up(1:7,:)=irf1ups(1:7,:); irf1down(1:7,:)=irf1downs(1:7,:);
ir0neu(1:7,:)=ir0neus(1:7,:); ir1neu(1:7,:)=ir1neus(1:7,:); 
irf0neuup(1:7,:)=irf0neuups(1:7,:); irf0neudown(1:7,:)=irf0neudowns(1:7,:); irf1neuup(1:7,:)=irf1neuups(1:7,:); irf1neudown(1:7,:)=irf1neudowns(1:7,:);

% Consumption
[ir0s, ir1s, irf0ups, irf0downs, irf1ups, irf1downs, ...
    ir0neus, ir1neus, irf0neuups, irf0neudowns, irf1neuups, irf1neudowns]=tvar_2s(ucl,lcl,10,colsv,shock);
ir0(8,:)=ir0s(2,:); ir1(8,:)=ir1s(2,:);
irf0up(8,:)=irf0ups(2,:); irf0down(8,:)=irf0downs(2,:); irf1up(8,:)=irf1ups(2,:); irf1down(8,:)=irf1downs(2,:);
ir0neu(8,:)=ir0neus(2,:); ir1neu(8,:)=ir1neus(2,:); 
irf0neuup(8,:)=irf0neuups(2,:); irf0neudown(8,:)=irf0neudowns(2,:); irf1neuup(8,:)=irf1neuups(2,:); irf1neudown(8,:)=irf1neudowns(2,:);

% Investment
[ir0s, ir1s, irf0ups, irf0downs, irf1ups, irf1downs, ...
    ir0neus, ir1neus, irf0neuups, irf0neudowns, irf1neuups, irf1neudowns]=tvar_2s(ucl,lcl,11,colsv,shock);
ir0(9,:)=ir0s(2,:); ir1(9,:)=ir1s(2,:);
irf0up(9,:)=irf0ups(2,:); irf0down(9,:)=irf0downs(2,:); irf1up(9,:)=irf1ups(2,:); irf1down(9,:)=irf1downs(2,:);
ir0neu(9,:)=ir0neus(2,:); ir1neu(9,:)=ir1neus(2,:); 
irf0neuup(9,:)=irf0neuups(2,:); irf0neudown(9,:)=irf0neudowns(2,:); irf1neuup(9,:)=irf1neuups(2,:); irf1neudown(9,:)=irf1neudowns(2,:);

% Saving Rate
[ir0s, ir1s, irf0ups, irf0downs, irf1ups, irf1downs, ...
    ir0neus, ir1neus, irf0neuups, irf0neudowns, irf1neuups, irf1neudowns]=tvar_2s(ucl,lcl,12,colsv,shock);
ir0(10,:)=ir0s(2,:); ir1(10,:)=ir1s(2,:);
irf0up(10,:)=irf0ups(2,:); irf0down(10,:)=irf0downs(2,:); irf1up(10,:)=irf1ups(2,:); irf1down(10,:)=irf1downs(2,:);
ir0neu(10,:)=ir0neus(2,:); ir1neu(10,:)=ir1neus(2,:); 
irf0neuup(10,:)=irf0neuups(2,:); irf0neudown(10,:)=irf0neudowns(2,:); irf1neuup(10,:)=irf1neuups(2,:); irf1neudown(10,:)=irf1neudowns(2,:);

end