%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function plot_var_bm(irf, irfup, irfdown)

irh=size(irf,2);

% Plot results - Positive shock
figure('units','centimeters','position',[0 0 15 15])
hold on
subplot(3,3,1)
h=plot(1:irh,irf(2,:),'-sb',1:irh,irfup(2,:),'--b',1:irh,irfdown(2,:),'--b');
title('GDP');
subplot(3,3,2)
h=plot(1:irh,irf(8,:),'-sb',1:irh,irfup(8,:),'--b',1:irh,irfdown(8,:),'--b');
title('Consumption');
subplot(3,3,3)
h=plot(1:irh,irf(9,:),'-sb',1:irh,irfup(9,:),'--b',1:irh,irfdown(9,:),'--b');
title('Investment');
subplot(3,3,4)
h=plot(1:irh,irf(10,:),'-sb',1:irh,irfup(10,:),'--b',1:irh,irfdown(10,:),'--b');
title('Saving Rate');
subplot(3,3,5)
h=plot(1:irh,irf(4,:),'-sb',1:irh,irfup(4,:),'--b',1:irh,irfdown(4,:),'--b');
title('Gov. Revenues');
subplot(3,3,6)
h=plot(1:irh,irf(5,:),'-sb',1:irh,irfup(5,:),'--b',1:irh,irfdown(5,:),'--b');
title('Gov. Spending');
subplot(3,3,7)
h=plot(1:irh,irf(3,:),'-sb',1:irh,irfup(3,:),'--b',1:irh,irfdown(3,:),'--b');
title('Inflation');
subplot(3,3,8)
h=plot(1:irh,irf(7,:),'-sb',1:irh,irfup(7,:),'--b',1:irh,irfdown(7,:),'--b');
title('FFR');
subplot(3,3,9)
h=plot(1:irh,irf(6,:),'-sb',1:irh,irfup(6,:),'--b',1:irh,irfdown(6,:),'--b');
title('Switching V.');
hold off


end