%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function plot_tvar_bm(irf0, irf1, irf0up, irf0down, irf1up, irf1down)
irh=size(irf0,2);

% Plot results - Positive shock
figure('units','centimeters','position',[0 0 15 15])
hold on
subplot(3,3,1)
h=plot(1:irh,irf0(2,:),'-sg',1:irh,irf0up(2,:),'--g',1:irh,irf0down(2,:),'--g',1:irh,irf1(2,:),'-*r',1:irh,irf1up(2,:),'--r',1:irh,irf1down(2,:),'--r');
title('GDP');
subplot(3,3,2)
h=plot(1:irh,irf0(8,:),'-sg',1:irh,irf0up(8,:),'--g',1:irh,irf0down(8,:),'--g',1:irh,irf1(8,:),'-*r',1:irh,irf1up(8,:),'--r',1:irh,irf1down(8,:),'--r');
title('Consumption');
subplot(3,3,3)
h=plot(1:irh,irf0(9,:),'-sg',1:irh,irf0up(9,:),'--g',1:irh,irf0down(9,:),'--g',1:irh,irf1(9,:),'-*r',1:irh,irf1up(9,:),'--r',1:irh,irf1down(9,:),'--r');
title('Investment');
subplot(3,3,4)
h=plot(1:irh,irf0(10,:),'-sg',1:irh,irf0up(10,:),'--g',1:irh,irf0down(10,:),'--g',1:irh,irf1(10,:),'-*r',1:irh,irf1up(10,:),'--r',1:irh,irf1down(10,:),'--r');
title('Saving Rate');
subplot(3,3,5)
h=plot(1:irh,irf0(4,:),'-sg',1:irh,irf0up(4,:),'--g',1:irh,irf0down(4,:),'--g',1:irh,irf1(4,:),'-*r',1:irh,irf1up(4,:),'--r',1:irh,irf1down(4,:),'--r');
title('Gov. Revenues');
subplot(3,3,6)
h=plot(1:irh,irf0(5,:),'-sg',1:irh,irf0up(5,:),'--g',1:irh,irf0down(5,:),'--g',1:irh,irf1(5,:),'-*r',1:irh,irf1up(5,:),'--r',1:irh,irf1down(5,:),'--r');
title('Gov. Spending');
subplot(3,3,7)
h=plot(1:irh,irf0(3,:),'-sg',1:irh,irf0up(3,:),'--g',1:irh,irf0down(3,:),'--g',1:irh,irf1(3,:),'-*r',1:irh,irf1up(3,:),'--r',1:irh,irf1down(3,:),'--r');
title('Inflation');
subplot(3,3,8)
h=plot(1:irh,irf0(7,:),'-sg',1:irh,irf0up(7,:),'--g',1:irh,irf0down(7,:),'--g',1:irh,irf1(7,:),'-*r',1:irh,irf1up(7,:),'--r',1:irh,irf1down(7,:),'--r');
title('FFR');
subplot(3,3,9)
h=plot(1:irh,irf0(6,:),'-sg',1:irh,irf0up(6,:),'--g',1:irh,irf0down(6,:),'--g',1:irh,irf1(6,:),'-*r',1:irh,irf1up(6,:),'--r',1:irh,irf1down(6,:),'--r');
title('Switching V.');
hold off


end