%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [mult, bands]=multiplier_m2(hor,gdpirf,gdpirf_mat,nomgdp,rrabs)

neps=size(rrabs,2);
reps=size(gdpirf_mat,1);
abs_gdp=nan(neps,1); abs_gdp_mat=nan(neps,1); mult_mat=nan(reps,1);

for j=1:neps
    abs_gdp(j)=sum(gdpirf(1,1:hor).*nomgdp(j));
end

mult=mean(abs_gdp./rrabs);

for j=1:reps
    for jj=1:neps
        abs_gdp_mat(jj)=sum(gdpirf_mat(j,1:hor).*nomgdp(jj));
    end
    
    mult_mat(j)=mean(abs_gdp_mat./rrabs);
end

bands=[prctile(mult_mat,16) prctile(mult_mat,84)];
      
end