%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [extremes, delay]=get_extremes(indata)
    
    [Tg, Ng]=size(indata);

    % Here the different starting and ending points of the time series are
    % determined and the delays in the arrival of data are stored

    extremes=zeros(2,Ng);
    delay=zeros(1,Ng);

    for vv=1:Ng
        variable=indata(:,vv);
        init=1;
        fine=Tg;
        rr=Tg;
        while isnan(variable(init))==1
            init=init+1;
        end
        while isnan(variable(fine))==1
            fine=fine-1;
        end
        while isnan(variable(rr,1))==1
            rr=rr-1;
        end
    extremes(:,vv)=[init; fine];
    delay(vv)=Tg-rr;
    end
   
    
end

