%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Table 2 Main Text - Fiscal Multipliers
clear

% GDP Multiplier - Linear Model
[~, ~, ~, ~, ~, ~, ~, var_mult_gdp]=vvar_2s(84,16,5,5,1);

% GDP Multiplier - Sign Nonlin - Pos. and Neg. Shocks
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, varsn_mult_gdp]=varsn_2s(84,16,5,5,1);

% GDP Multiplier - TVAR - Low and High Unc. Regime multipliers
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, tvar_mult_gdp]=tvar_2s(84,16,5,5,1);

% GDP Multiplier - TVARSN - Positive Shock (Low and High Unc. Regime) and Negative Shock (Low and High Unc. Regime) multipliers
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, tvarsn_mult_gdp]=tvarsn_2shocks(84,16,5,5,1);

Description ={'VAR Multiplier'; 'VARSN Mult. Positive Shock'; 'VARSN Mult. Negative Shock';
              'TVAR Mult. Regime 0'; 'TVAR Mult. Regime 1'; 'TVARSN Mult. Pos. Shock Regime 0'
              'TVARSN Mult. Pos. Shock Regime 1'; 'TVARSN Mult. Neg. Shock Regime 0';
              'TVARSN Mult. Neg. Shock Regime 1'};
Firstrow = {'Name','Multiplier','LCI','UCI'};
Multipl=[var_mult_gdp; varsn_mult_gdp; tvar_mult_gdp; tvarsn_mult_gdp];
T = table(Description,Multipl(:,1),Multipl(:,2),Multipl(:,3),'VariableNames',Firstrow);
writetable(T,'MultipliersH1.xlsx')

