%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Table 1 Main Text - Nonlinearity Tests

[pvabs_gdp, pvcum_gdp]=tvarsn_2s_tests(5,5,1);
[pvabs_con, pvcum_con]=tvarsn_2s_tests(5,10,1);
[pvabs_inv, pvcum_inv]=tvarsn_2s_tests(5,11,1);
[pvabs_sav, pvcum_sav]=tvarsn_2s_tests(5,12,1);

Description={'Positive Shock lin. model vs. Positive Shock in Reg. 0';
    'Positive Shock lin. model vs. Positive Shock in Reg. 1';
    'Negative Shock lin. model vs. Negative Shock in Reg. 0';
    'Negative Shock lin. model vs. Negative Shock in Reg. 1';
    'Positive Shock in Reg. 0 vs. Positive Shock in Reg. 1';
    'Negative Shock in Reg. 0 vs. Negative Shock in Reg. 1';
    'Negative Shock lin. model vs. Positive Shock lin. model';
    'Positive Shock in Reg. 0 vs. Negative Shock in Reg. 0';
    'Positive Shock in Reg. 1 vs. Negative Shock in Reg. 1'};

Firstrow={'Description','MaxAbsGDP','CumGDP','MaxAbsCON','CumCON','MaxAbsINV','CumINV','MaxAbsSAVE','CumSAVE'};
T = table(Description,pvabs_gdp, pvcum_gdp,pvabs_con, pvcum_con,pvabs_inv, ...
    pvcum_inv,pvabs_sav, pvcum_sav,'VariableNames',Firstrow);
writetable(T,'NonlinTests.xlsx')