%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%% IRF Plots in the main text and Appendix  %%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%        Main Text           %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Figure 1 Main Text - VAR JLN Macro Uncertainty
[ir, irfup, irfdown] = var_2s_fp(84,16,5,1);  
plot_var_bm(-ir, -irfup, -irfdown)
print('MacJLN_VAR_2S','-dpng')

% Figure 4 Main Text - TVAR JLN Macro Uncertainty
[ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,5,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('MacJLN_TVAR_2S','-dpng')

% Figures 5 and 6 Main Text - TVAR with Sign Nonlin. JLN Macro Uncertainty
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,5,1);  
% Figure 5
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacJLN_TVARSN_2S_Pos','-dpng')
% Figure 6
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('MacJLN_TVARSN_2S_Neg','-dpng')

% Figures 7 and 8 Main Text - TVAR with Sign Nonlin. JLN Macro Uncertainty - Neutralized Reaction of FFR
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,5,1);
% Figure 7
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacJLN_TVARSN_2SNEU_Pos','-dpng')
% Figure 8
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('MacJLN_TVARSN_2SNEU_Neg','-dpng')

% Figures 9 and 10 Main Text - Generalized IRFs - TVAR with Sign Nonlin. JLN Macro Uncertainty 
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_girf_fp(84,16,5);  
% Figure 9
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacJLN_TVARSN_2S_GIRF_Pos','-dpng');
% Figure 10
plot_tvar_bm(irn0, irn1, irfn0up, irfn0down, irfn1up, irfn1down)
print('MacJLN_TVARSN_2S_GIRF_Neg','-dpng');

% Figures 11 and 12 Main Text - TVAR with Sign Nonlin. JLN Macro Uncertainty - Residuals of a Regression of the Uncertainty Measure on Q-o-Q GDP growth 
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,13,1); 
% Figure 11
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacJLNRes_TVARSN_2S_Pos','-dpng');
% Figure 12
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('MacJLNRes_TVARSN_2S_Neg','-dpng');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%        Appendix          %%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Figures 1 and 2 Appendix - VAR with Sign Nonlin. JLN Macro Uncertainty 
[irp, irn, irfpup, irfpdown, irfnup, irfndown] = varsn_2s_fp(84,16,5,1); 
% Figure 1
plot_var_bm(irp, irfpup, irfpdown)
print('MacJLN_VARSN_2S_Pos','-dpng')
% Figure 2
plot_var_bm(-irn, -irfnup, -irfndown)
print('MacJLN_VARSN_2S_Neg','-dpng')

% Figure 3 Appendix - TVAR CCM Macro Uncertainty
[ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,6,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('MacCCM_TVAR_2S','-dpng')

% Figures 4 and 5 Appendix - TVAR with Sign Nonlin. CCM Macro Uncertainty 
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,6,1);  
% Figure 4
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacCCM_TVARSN_2S_Pos','-dpng');
% Figure 5
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('MacCCM_TVARSN_2S_Neg','-dpng');

% Figure 6 Appendix - TVAR Rossi & Sekhposyan Macro Uncertainty
[ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,7,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('MacRS_TVAR_2S','-dpng')

% Figures 7 and 8 Appendix - TVAR with Sign Nonlin. Rossi & Sekhposyan Macro Uncertainty
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,7,1);  
% Figure 7
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacRS_TVARSN_2S_Pos','-dpng');
% Figure 8
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('MacRS_TVARSN_2S_Neg','-dpng');

% Figure 9 Appendix - TVAR EPU 
[ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,11,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('EPU_TVAR_2S','-dpng')

% Figures 10 and 11 Appendix  - TVAR with Sign Nonlin. EPU
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,11,1); 
% Figure 10
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('EPU_TVARSN_2S_Pos','-dpng');
% Figure 11
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('EPU_TVARSN_2S_Neg','-dpng');

% Figure 12 Appendix - TVAR CCM Financianl Uncertainty
[ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,9,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('FinCCM_TVAR_2S','-dpng')

% Figures 13 and 14 Appendix - TVAR with Sign Nonlin. CCM Financial Uncertainty
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,9,1);  
% Figure 13
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('FinCCM_TVARSN_2S_Pos','-dpng');
% Figure 14
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('FinCCM_TVARSN_2S_Neg','-dpng');

% Figure 15 Appendix - TVAR LMN Financianl Uncertainty
[ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,8,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('FinJLN_TVAR_2S','-dpng')

% Figures 16 and 17 Appendix - TVAR with Sign Nonlin. LMN Financial Uncertainty
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,8,1);
% Figure 16
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('FinJLN_TVARSN_2S_Pos','-dpng');
% Figure 17
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('FinJLN_TVARSN_2S_Neg','-dpng');

% Figure 18 Appendix - TVAR VXO 
[ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,10,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('VXO_TVAR_2S','-dpng')

% Figures 19 and 20 Appendix - TVAR with Sign Nonlin. VXO
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,10,1); 
% Figure 19
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('VXO_TVARSN_2S_Pos','-dpng');
% Figure 20
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('VXO_TVARSN_2S_Neg','-dpng');

% Figures 21 and 22 Appendix - TVAR with Sign Nonlin. A&G Switching Variable
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,12,1); 
% Figure 21
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('AGS_TVARSN_2S_Pos','-dpng');
% Figure 22
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('AGS_TVARSN_2S_Neg','-dpng');

% Figure 23 Appendix - TVAR JLN Macro Uncertainty - Neutralized Reaction of FFR
[~, ~, ~, ~, ~, ~, ir0, ir1, irf0up, irf0down, irf1up, irf1down] = tvar_2s_fp(84,16,5,1);  
plot_tvar_bm(-ir0, -ir1, -irf0up, -irf0down, -irf1up, -irf1down)
print('MacJLN_TVAR_2SNEU','-dpng')

% Figures 24 and 25 Appendix - TVAR with Sign Nonlin. JLN Macro Uncertainty
% IRFs from the Iterated FGLS estimator
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_rsvcv_fp(84,16,5);  
% Figure 24
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacJLN_TVARSN_2S_RSVCV_Pos','-dpng');
% Figure 25
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('MacJLN_TVARSN_2S_RSVCV_Neg','-dpng');

% Figures 26 and 27 Appendix - TVAR with Sign Nonlin. JLN Macro Uncertainty
% IRFs estimated using as shocks the residuals of a regression of RR tax
% shocks on Ramey's G shocks
[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, ...
    irfn0up, irfn0down, irfn1up, irfn1down] = tvarsn_2s_fp(84,16,5,2); 
% Figure 26
plot_tvar_bm(irp0, irp1, irfp0up, irfp0down, irfp1up, irfp1down)
print('MacJLN_TVARSN_2S_ShRES_Pos','-dpng');
% Figure 27
plot_tvar_bm(-irn0, -irn1, -irfn0up, -irfn0down, -irfn1up, -irfn1down)
print('MacJLN_TVARSN_2S_ShRES_Neg','-dpng');

