%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% "Tax Shocks with High and Low Uncertainty" 
% Bertolotti F. and Marcellino M.
% Journal of Applied Econometrics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% Figure 13 Main Text, Comparison of the different Uncertainty Variables used
clear 

% Plot of uncertainty measures and related threshold
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_mjln, ~, thresh_mjln]=tvarsn_2shocks(84,16,5,5,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_mccm, ~, thresh_mccm]=tvarsn_2shocks(84,16,5,6,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_mrs, ~, thresh_mrs]=tvarsn_2shocks(84,16,5,7,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_fjln, ~, thresh_fjln]=tvarsn_2shocks(84,16,5,8,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_fccm, ~, thresh_fccm]=tvarsn_2shocks(84,16,5,9,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_vxo, ~, thresh_vxo]=tvarsn_2shocks(84,16,5,10,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_epu, ~, thresh_epu]=tvarsn_2shocks(84,16,5,11,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_ags, ~, thresh_ags]=tvarsn_2shocks(84,16,5,12,1);
[~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata_mjlnr, ~, thresh_mjlnr]=tvarsn_2shocks(84,16,5,13,1);


T0=min([estdata_mjln(1,1) estdata_mccm(1,1) estdata_mrs(1,1) estdata_fjln(1,1) estdata_fccm(1,1) ...
        estdata_vxo(1,1) estdata_epu(1,1) estdata_ags(1,1) estdata_mjlnr(1,1)]);
T1=2007.75;
dates=[T0:0.25:T1]';
T=size(dates,1);

% Plot 
hold on
subplot(3,3,1)
plot(dates,[nan(T-size(estdata_mjln,1),1); estdata_mjln(:,end-4)],dates,[nan(T-size(estdata_mjln,1),1); ones(size(estdata_mjln,1),1).*thresh_mjln]);
xlim([T0 T1])
title('Macro Unc. JLN');
subplot(3,3,2)
plot(dates,[nan(T-size(estdata_mccm,1),1); estdata_mccm(:,end-4)],dates,[nan(T-size(estdata_mccm,1),1); ones(size(estdata_mccm,1),1).*thresh_mccm]);
xlim([T0 T1])
title('Macro Unc. CCM');
subplot(3,3,3)
plot(dates,[nan(T-size(estdata_mrs,1),1); estdata_mrs(:,end-4)],dates,[nan(T-size(estdata_mrs,1),1); ones(size(estdata_mrs,1),1).*thresh_mrs]);
xlim([T0 T1])
title('Macro Unc. RS');
subplot(3,3,4)
plot(dates,[nan(T-size(estdata_fjln,1),1); estdata_fjln(:,end-4)],dates,[nan(T-size(estdata_fjln,1),1); ones(size(estdata_fjln,1),1).*thresh_fjln]);
xlim([T0 T1])
title('Fin. Unc. JLN');
subplot(3,3,5)
plot(dates,[nan(T-size(estdata_fccm,1),1); estdata_fccm(:,end-4)],dates,[nan(T-size(estdata_fccm,1),1); ones(size(estdata_fccm,1),1).*thresh_fccm]);
xlim([T0 T1])
title('Fin. Unc. CCM');
subplot(3,3,6)
plot(dates,[nan(T-size(estdata_vxo,1),1); estdata_vxo(:,end-4)],dates,[nan(T-size(estdata_vxo,1),1); ones(size(estdata_vxo,1),1).*thresh_vxo]);
xlim([T0 T1])
title('VXO');
subplot(3,3,7)
plot(dates,[nan(T-size(estdata_epu,1),1); estdata_epu(:,end-4)],dates,[nan(T-size(estdata_epu,1),1); ones(size(estdata_epu,1),1).*thresh_epu]);
xlim([T0 T1])
title('EPU');
subplot(3,3,8)
plot(dates,[nan(T-size(estdata_ags,1),1); estdata_ags(:,end-4)],dates,[nan(T-size(estdata_ags,1),1); ones(size(estdata_ags,1),1).*thresh_ags]);
xlim([T0 T1])
title('A&G Switching Var.');
subplot(3,3,9)
plot(dates,[nan(T-size(estdata_mjlnr,1),1); estdata_mjlnr(:,end-4)],dates,[nan(T-size(estdata_mjlnr,1),1); ones(size(estdata_mjlnr,1),1).*thresh_mjlnr]);
xlim([T0 T1])
title('Macro Unc. Res. JLN');
hold off


%% Figure 2 Main Text - Plot of JLN Macro Uncertainty together with NBER Recession Bands

datesnum=datenum([floor(dates), (dates-floor(dates)).*12 + 1, ones(size(dates))]);
plot(datesnum,[nan(T-size(estdata_mjln,1),1); estdata_mjln(:,end-4)],datesnum,[nan(T-size(estdata_mjln,1),1); ones(size(estdata_mjln,1),1).*thresh_mjln]);
ylim([0.85 1.15])
ax = gca;
ax.XTick = datesnum(1:8:end);
datetick('x','yyyy','keepticks')
recessionplot
title('Jurado, Ludvigson and Ng Macro Unc. and Regimes');
print('MacJLN_Regimes_TVARSN','-dpng')

%% Figure 3 Main Text - Distribution of Romer and Romer Shocks

[irp0, irp1, irn0, irn1, irfp0up, irfp0down, irfp1up, irfp1down, irfn0up, irfn0down, ...
    irfn1up, irfn1down, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, ~, estdata, ~, thresh]=tvarsn_2shocks(84,16,5,5,1);

% Distribution of Shocks
d=estdata(:,end-3); % Definition of regimes
Vp=estdata(:,end-2); % Positive Romer and Romer tax shocks
Vn=estdata(:,end-1); % Negative Romer and Romer tax shocks
Vm=estdata(:,end); % Romer and Romer monetary policy shocks (Coibion's update)
V=Vp+Vn;

% Distribution of Shocks
hold on
subplot(2,1,1)
hist(V(d==0),20)
title('RR Shocks Distribution in Low Unc.');
subplot(2,1,2)
hist(V(d==1),20)
title('RR Shocks Distribution in High Unc.');
hold off
print('RRShocksDistribution','-dpng');

%% Additional estimates used in the text regarding the magnitude of the response of JLN macro uncertainty to shocks
% Refer to introduction of Section 3 and Subsections 3.2.6 in the paper for the use of such statistics

% Additional Stastistics on the distribution of shocks over the uncertainty regimes
means = [mean(V(d==0)), mean(V(d==1))]; % Average size of the shock in the low and high uncertainty regime
stdev = [std(V(d==0)), std(V(d==1))];   % Standard deviation of the size of the shock in the low and high uncertainty regime
percR0 = [sum(V(d==0)>0)/sum(V(d==0)~=0), sum(V(d==0)<0)/sum(V(d==0)~=0)];  % Percentage of positive and negative shocks among shocks occuring in the low-uncertainty regime
percR1 = [sum(V(d==1)>0)/sum(V(d==1)~=0), sum(V(d==1)<0)/sum(V(d==1)~=0)];  % Percentage of positive and negative shocks among shocks occuring in the high-uncertainty regime
percpos = [sum(V(d==0)>0)/sum(V>0), sum(V(d==1)>0)/sum(V>0)];   % Percentage of positive shocks occuring in the high- vs. low- uncertainty regime
percneg = [sum(V(d==0)<0)/sum(V<0), sum(V(d==1)<0)/sum(V<0)];   % Percentage of negative shocks occuring in the high- vs. low- uncertainty regime

% Magnitude of Uncertainty Response and Regime Switch
Z=estdata(:,end-4);
uncmean0=mean(Z(d==0)); % Mean of JLN macro uncertainty in the low-uncertainty regime
uncmean1=mean(Z(d==1)); % Mean of JLN macro uncertainty in the high-uncertainty regime

maxrespn0=max(irn0(6,:)); % Maxmium size of the response of macro uncertainty to a negative shock in the low-uncertainty regime
maxrespp0=max(irp0(6,:)); % Maxmium size of the response of macro uncertainty to a positive shock in the low-uncertainty regime
minrespn1=min(irn1(6,:)); % Minimum size of the response of macro uncertainty to a negative shock in the high-uncertainty regime
minrespp1=min(irp1(6,:)); % Minimum size of the response of macro uncertainty to a positive shock in the high-uncertainty regime

% Display the value of the JLN macro uncertainty variable at the mean, at
% the extreme values after the response to a tax shcok and compare it to
% the threshold value defining regimes (last column)

[uncmean0 uncmean0+maxrespn0 uncmean0+maxrespp0 thresh;
 uncmean1 uncmean1+minrespn1 uncmean1+minrespp1 thresh]

% Average Percentile of the Uncertainty Distribution when different types of shocks occur
avgunc_anyshock=mean(Z(V~=0)); avgperc_anyshock=sum(Z<=avgunc_anyshock)/size(Z,1);
avgunc_posshock=mean(Z(V>0)); avgperc_posshock=sum(Z<=avgunc_posshock)/size(Z,1);
avgunc_negshock=mean(Z(V<0)); avgperc_negshock=sum(Z<=avgunc_negshock)/size(Z,1);
[avgunc_anyshock, avgunc_posshock, avgunc_negshock;
 avgperc_anyshock, avgperc_posshock, avgperc_negshock];

% Compute the average length of the spell of the two regimes
T=size(d,1);
it=1;
for j=1:T-1
    if d(j)==0 && d(j+1)==1
        sw(it)=j+1;
        it=it+1;
    elseif d(j)==1 && d(j+1)==0
        sw(it)=j;
        it=it+1;
    end
end
sw=sw';

% High-Uncertainty Regime Dates
estdata(sw,1)

clear spell
% Average length of High Unc regime
for j=1:size(sw,1)/2
    spell(j)=sw((j-1)*2+2)-sw((j-1)*2+1)+1;
end

% Computes the average length of the high-uncertainty regime
avglenr1=mean(spell);

clear spell
% Average length of Low Unc regime
spell(1)=sw(1)-1;
for j=2:(size(sw,1)/2)-1
    spell(j)=sw(j*2+1)-sw(j*2);
end
spell=[spell T-sw(end)];

 % Computes the average length of the low-uncertainty regime
avglenr0=mean(spell);

%% Correlation/Regression Coefficient between RR Monetary Policy Shocks and RR Tax Shocks in the high-uncertainty regime
% See Subsection 2.3 for the use and comment of such data

% Correlation between Positive RR tax shocks and RR MP shocks - High Unc. Regime
corr(Vp(d==1),Vm(d==1))
% Regression coefficients and statistical significance of the regression of Positive RR tax shocks and RR MP shocks - High Unc. Regime
[bVpVmr1, bVpVmr1int,~, ~, bVpVmr1stats]=regress(Vp(d==1),[ones(size(Vm(d==1),1),1) Vm(d==1)],0.1);

