

% this code reproduces Figure 1 (replication of NRI and its components by HLW)


clear all, close all; clc;
addpath('Procedures_repli');
addpath('Data');
rng(3000); 


Model_lam   = 1;                  
Model_z     = 1;                  
Model_theta = [0;0];            
bin         = 10000;
nd          = 30000;  
burn_ur     = bin;
N_vola      = 2;                
A0          = 1;


data = csvread('data_repl.txt');

y          = data(:,1);
rr         = data(:,2);
pid        = data(:,3);
output_gap = data(:,4);
g_est      = data(:,5);
rstar_est  = data(:,6);
date       = data(:,7);
z_HLW      = data(:,8);

T = 223;

%% Priors

bel_vepsrc  = 0.5;         str_vepsrc= 0.005;    c0_vepsrc  = T*str_vepsrc; C0_vepsrc  = c0_vepsrc*bel_vepsrc; %  
bel_vepspi  = 1;           str_vepspi= 0.005;    c0_vepspi  = T*str_vepspi; C0_vepspi  = c0_vepspi*bel_vepspi; %  
bel_kappa   = 0.001;       str_kappa = 0.05;     c0_kappa   = T*str_kappa; C0_kappa    = c0_kappa*bel_kappa; %  kappa
bel_vepsz   = 0.01;        str_vepsz = 0.05;     c0_vepsz   = T*str_vepsz; C0_vepsz    = c0_vepsz*bel_vepsz; %  z
    
a0_kappa = [1-0.25; 0];       A0_kappa  = [0.25^2  0; 0 A0^2];        % variance time-varying output drift: constant term and stdv
a0_z1    = [1; 0; 0.25];      A0_z1     = [0.05^2  0 0; 0 0.2^2 0; 0 0 0.1^2]; 

a0_phi   = [1.55;0.9;-0.1];     A0_phi   = [0.25^2 0 0; 0 0.25^2 0; 0 0 0.03^2];  % AR Parameter and a_r
a0_omega = 0.9; A0_omega = 0.2^2;   
a0_beta  = [0.8;0.2]; A0_beta = [0.1^2 0; 0 0.1^2];  % Phillips curve parameter

a0_SV(:,:,1) = [log(1); 0];   A0_SV(:,:,1) = [1^2 0; 0 A0^2];    % variance trend output
a0_SV(:,:,2) = [log(1); 0];    A0_SV(:,:,2) = [1^2 0; 0 A0^2];    % variance output gap
p0=0.5; A0 = 1;

%% Initialization Gibbs sampler
% Parameters
s_sigma_pi     = sqrt(bel_vepspi);
s_phi1        = a0_phi(1,1);
s_phi2        = a0_phi(2,1)-a0_phi(1,1);
s_kappa0      = 0;
s_sigma_kappa = 0.05;
s_sigma_gamma = [a0_SV(2,1,1);a0_SV(2,1,2)];
s_a_r         = -0.05;
s_z0          = 0;
s_sigma_z     = 0.05;
s_sigma_rc    = 1;
s_omega       = 0.9;
s_beta1       = 0.9;
s_beta2       = 0.8;
s_c           = 1;

% States
[hp_trend,hp_cycle] = hpfilter(y,12800);
s_ystar = hp_trend; s_cycle = hp_cycle;
s_kappa_tilde = zeros(T,1);
s_kappa = s_kappa0 + s_sigma_kappa*s_kappa_tilde;

[hp_trend,hp_cycle] = hpfilter(rr,12800);
s_rstar = hp_trend; s_rc = hp_cycle;
s_z_tilde = zeros(T,1); s_z = s_z0 + s_sigma_z*s_z_tilde;


% Stochastic volatilities
load('table_mix10'); table_mix=table_mix10;
[iota]    = ini_sv(T,N_vola,table_mix);
s_h_tilde = cumsum(randn(T,N_vola));
s_h0      = [a0_SV(1,1,1);a0_SV(1,1,2)];%zeros(N_vola,1);
s_h       = [ones(T,1)*s_h0(1,1),ones(T,1)*s_h0(2,1)];%zeros(T,N_vola);

% Binary indicators
s_p_lambda = 0;
if Model_lam==0; s_lambda=0; else s_lambda=1; end
s_p_theta = zeros(N_vola,1); s_theta = zeros(N_vola,1);
if Model_theta(1,1)==0; s_theta(1,1)=0; else s_theta(1,1)=1; end
if Model_theta(2,1)==0; s_theta(2,1)=0; else s_theta(2,1)=1; end


store_states_one_sided = zeros(T,9,nd-bin); 

%% Gibbs sampler
for j=1:bin+nd
     
    if (mod(j, 100) ==0)
       disp([num2str( j) ' loops... ']);
    end
        
    
    % Parameter
    res_kappa = s_kappa - lagmatrix(s_kappa,1); res_kappa=res_kappa(2:end);
    [sigma_kappa] = IG_post(res_kappa,c0_kappa,C0_kappa); 
    s_sigma_kappa = sqrt(sigma_kappa);   
            
    res_z = s_z - lagmatrix(s_z,1); res_z=res_z(2:end);
    [sigma_z] = IG_post(res_z,c0_vepsz,C0_vepsz); 
    s_sigma_z = sqrt(sigma_z);
       
    
    yy = rr - s_z; yy = yy - s_omega*lagmatrix(yy,1); yy = yy(2:end);
    xx = 4*s_kappa; xx = xx - s_omega*lagmatrix(xx,1); xx = xx(2:end);
    [s_c var_eps] = NIG_post2(yy,xx,1,0.05^2,c0_vepsrc,C0_vepsrc);
    s_sigma_rc = sqrt(var_eps);
    
     
    % IS curve (output gap) parameter
    [s_phi1,s_phi2,s_a_r] = block_rho(s_cycle,s_h(:,2),a0_phi,A0_phi,s_phi1,s_phi2,1,0.5*(lagmatrix(s_rc,1)+lagmatrix(s_rc,2)),s_a_r);

    % omega
    ydata = s_rc(2:end); xdata = lagmatrix(s_rc,1); xdata = xdata(2:end);
    [b_draw] = N_post(ydata,xdata,a0_omega,A0_omega,s_sigma_rc^2);
    if b_draw < 1; 
        s_omega    = b_draw;
    end
    
    
    % Phillips curve parameter           
    ydata2 = pid(2:end); xdata2 = lagmatrix(pid,1); xdata2 = [xdata2(2:end) s_cycle(2:end)];    
    [para sigma_pi] = NIG_post2(ydata2,xdata2,a0_beta,A0_beta,c0_vepspi,C0_vepspi);     
    s_beta1    = para(1,1);
    s_beta2    = para(2,1);
    s_sigma_pi = sqrt(sigma_pi);    
  
    
    % Stochastic volatilities: binary indicators are set to zero to obtain
    % constant vola (as in HLW)
    [w,Sigma] = SV_temp(T,N_vola,s_ystar,s_cycle,s_kappa,s_phi1,s_phi2,iota,table_mix);
    for k=1:N_vola
        z = 2*[ones(T,1) s_h_tilde(:,k)]; 
        [s_p_theta(k,1),s_theta(k,1),draw_b]=Block1(w(:,k),z,a0_SV(:,:,k),A0_SV(:,:,k),[],[],p0,j,burn_ur,Model_theta(k,1),Sigma(:,k));
        s_h0(k,1)=draw_b(1,1); s_sigma_gamma(k,1)=draw_b(1,2);  
    end
    s_h = repmat(s_h0',T,1) + s_h_tilde.*repmat(s_sigma_gamma',T,1); % Adjust s_h to new estimates s_h0 and s_sigma_gamma
    
   %% States 
  
  pi_ss = pid-s_beta1*(lagmatrix(pid,1));
  [states,states_onesided]  = states_replication(y,pi_ss,s_beta2,s_sigma_pi,T,s_sigma_kappa,s_phi1,s_phi2,s_kappa0,s_lambda,s_h,rr,s_a_r,s_sigma_z,s_sigma_rc,s_omega,s_z0,s_c);
 
    s_ystar         = states(:,1);
    s_kappa_tilde   = states(:,2);
    s_z_tilde       = states(:,3);
    s_rc            = states(:,4);
    s_cycle         = states(:,5);
    s_kappa         = states(:,6);
    s_z             = states(:,7);
    s_rstar         = states(:,8);
    
      
   
    % Stochastic volatilities: states (s_h, s_h_tilde)
    [s_h_tilde,s_h,iota] = Block2(T,s_ystar,s_cycle,s_kappa,s_h,s_phi1,s_phi2,s_h0,s_sigma_gamma,s_theta,table_mix);

    
       
    
    if j>bin  
        
        store_states_one_sided(:,:,j-bin) = states_onesided;

    end      
    
end

%% Summarizing the results
mean_states_onesided    = mean(store_states_one_sided(:,:,:),3);   
lower_states_onesided   = prctile(store_states_one_sided(:,:,:),5,3);
upper_states_onesided   = prctile(store_states_one_sided(:,:,:),95,3);



figure
    subplot(2,2,1); confplot(date(2:end),[mean_states_onesided(2:end,7) rstar_est(2:end,1) ],lower_states_onesided(2:end,7), upper_states_onesided(2:end,7)); legend('HLW','model-one'); title('r-star-one');
    subplot(2,2,2); confplot(date(2:end),[4*mean_states_onesided(2:end,8) g_est(2:end,1)], 4*lower_states_onesided(2:end,8),4*upper_states_onesided(2:end,8));legend('HLW','model');title('Potential output growth');
    subplot(2,2,3); confplot(date(2:end),[mean_states_onesided(2:end,9) z_HLW(2:end,1) ],lower_states_onesided(2:end,9),upper_states_onesided(2:end,9)); legend('HLW','model'); title('z'); 
    subplot(2,2,4); confplot(date(2:end),[mean_states_onesided(2:end,5) output_gap(2:end,1) ],lower_states_onesided(2:end,5),upper_states_onesided(2:end,5)); legend('HLW','model'); title('output gap'); 


 
 
