function [states_twosided,states_onesided] = states_replication(y,pi_ss,s_beta2,s_sigma_pi,T,s_sigma_kappa,s_phi1,s_phi2,s_kappa0,s_lambda,s_h,rr,s_a_r,s_sigma_z,s_sigma_rc,s_omega,s_z0,s_c)

  

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %% Setting up SS matrices
ns = 8; dim = 5;

if size(s_h,2)==3; s_sigma_kappa=exp(s_h(:,3)); else s_sigma_kappa=ones(1,1,T)*s_sigma_kappa; end

Zt = zeros(3,ns,T);    

Zt(1,1,:) = 1; Zt(1,4,:) = 0; Zt(1,5,:) = 1;
Zt(2,4,:) = 1; Zt(2,7,:) = 1;
Zt(3,5,:) = s_beta2;

 
Ht = zeros(3,3,T);
Ht(1,1,:) = 0.0000001; 
Ht(2,2,:) = 0.0000001;  
Ht(3,3,:) = s_sigma_pi^2;  
At = [];




mu=zeros(ns,1);   



Tt = zeros(ns,ns,T);    Tt(1,1,:)=1; Tt(2,2,:)=1; Tt(1,2,:)=1;
Tt(3,3,:)=1; 
Tt(4,4,:)=s_omega; 
Tt(5,4,:)=0.5*s_a_r; Tt(5,5,:)=s_phi1; Tt(5,6,:)=s_phi2;Tt(5,8,:)=0.5*s_a_r;
Tt(6,5,:)=1; 
Tt(7,2,:)=4*s_c; Tt(7,3,:)= 1;
Tt(8,4,:)=1;


Kt = zeros(ns,dim,T);
Kt(1,1,:) = (exp(s_h(:,1)));
Kt(2,2,:) = s_sigma_kappa; 
Kt(3,3,:) = s_sigma_z;
Kt(4,4,:) = s_sigma_rc;
Kt(5,5,:) = (exp(s_h(:,2)));

Qt = eye(dim);

 %% Initialisation
S0=zeros(ns,1);

[hp_trend,hp_cycle] = hpfilter(y,1600);
S0(1,1) = hp_trend(1,1); % potential output
S0(2,1) = 1;

[hp_rtrend,hp_rcycle] = hpfilter(rr,1600);
S0(7,1) = hp_rtrend(1,1);



B=50;
obs=10000;
series = zeros(B+obs,8);
for a=3:obs
    
  series(a,4) = s_omega*series(a-1,4)+randn(1,1)*s_sigma_rc;
 
   series(a,5) = s_phi1*series(a-1,5)+s_phi2*series(a-2,5)+0.5*s_a_r*series(a-1,4)+0.5*s_a_r*series(a-2,4)+randn(1,1)*exp(s_h(1,2));  
   series(a,6) = series(a-1,5); 
   series(a,8) = series(a-1,4); 
   
end

P0=cov(series(B+1:obs-1,:));
P0(1,1)= 1000;
P0(2,2)= 0.5;
P0(3,3)= 0.5;
P0(7,7)= 1000;




yy = [y rr pi_ss];


%% Kalman filter and sampler
if s_lambda==0 % drop kappa from matrices
    Zt(:,2,:)=[];S0(2,:)=[];P0(:,2)=[];P0(2,:)=[];Qt(:,2)=[];Qt(2,:)=[];Tt(:,2,:)=[];Tt(2,:,:)=[];Kt(:,2,:)=[];Kt(2,:,:)=[];mu(2,:)=[];
end

[hStt,hPtt] = Kfilter_um(yy,Zt,At,S0,P0,Qt,Tt,Kt,Ht,mu);  

states_filter = hStt';


states_filter = hStt';
s_kappa_tilde_filter = states_filter(:,2);
s_kappa_filter = s_kappa0 + squeeze(s_sigma_kappa).*s_kappa_tilde_filter;


s_rc = states_filter(:,4);
s_rstar = states_filter(:,7);   

% draws from the filter (for one sided states) :
 draws_filter = zeros(T,ns);
 for s=1:T
 mean = hStt(:,s);
 var = hPtt(:,:,s);

 [R,p] = chol(var); 
 if p>0; R=fix_var(var,ns); end
 
 draws_filter(s,:) = mean' + randn(1,ns)*R; 
 end
 
 
 
kappa_one = draws_filter(:,2);  
   z_one  = draws_filter(:,3); 



    if s_lambda==1  
        
    [draws] = Ksampler(hStt,hPtt,Qt,Tt(1:5,:,:),Kt(1:5,:,:),mu(1:5,1)); 
     s_ystar       = draws(:,1);
     s_kappa_tilde = draws(:,2);
     s_z_tilde     = draws(:,3);
     s_rc          = draws(:,4);
     s_cycle       = draws(:,5);
   
     
     
else 
    [draws] = Ksampler(hStt,hPtt,Qt,Tt(1:2,:,:),Kt(1:2,:,:),mu(1:2,1)); 
    
  end
    
   %% Reconstructing time-varying kappa
s_kappa = draws(:,2);  
s_z     = draws(:,3);
s_rstar = s_c*4*s_kappa + s_z;    






states_twosided = [draws(:,1:5) s_kappa s_z s_rstar];
states_onesided = [draws_filter(:,1:7) kappa_one z_one];
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    