function [s_rho_1, s_rho_2, s_a_r]  = block_rho(s_cycle,s_hc,a0_rho,A0_rho,r1,r2,stat,gap,s_a_r)

x = [(s_cycle(2:end-1,1)-s_cycle(1:end-2,1))./exp(s_hc(3:end,1))  s_cycle(1:end-2,1)./exp(s_hc(3:end,1))];
y = s_cycle(3:end,1)./exp(s_hc(3:end,1));


x = [x gap(3:end)./exp(s_hc(3:end,1))];






if stat==1
    % Impose stationarity
    reject=1; count=0;
    while reject==1      
        post_mean = (A0_rho^(-1) + x'*x)^(-1) * (A0_rho^(-1)*a0_rho + x'*y);
        post_var  = (A0_rho^(-1) + x'*x)^(-1) ;
        coef1 = post_mean' + randn(1,3)*chol(post_var);
        coef1=coef1';
        rho1=coef1(1,1);
        rho2 = coef1(2,1)-coef1(1,1);
        
        if  coef1(2,1)<1
            reject=0;
            s_rho_1 = coef1(1,1);
            s_rho_2 = coef1(2,1)-coef1(1,1);
            s_a_r   = coef1(3,1); 

        else % reject draw if rho>0.98
            count=count+1;
        end
        if count==50; 
            s_rho_1=r1; s_rho_2=r2; s_a_r = s_a_r;
            reject=0; end % parameters not updated if restriction not met after 50 draws   
    end
else
    % Without imposing stationarity
    post_mean = (A0_rho^(-1) + x'*x)^(-1) * (A0_rho^(-1)*a0_rho + x'*y);
    post_var  = (A0_rho^(-1) + x'*x)^(-1) ;
    coef1 = post_mean' + randn(1,2)*chol(post_var);
    coef1 = coef1';
    rho1 = coef1(1,1);
    rho2 = coef1(2,1)-coef1(1,1);
end