% Use: draw random numbers for beta from posterior destribution Bayesian regression model
% Ref: mixture of notation

% Notation: a0 = prior AR coeff; A0 = strength of prior; var_eps = variance
% drawn in the previous step from IG distribution

function [b_draw] = N_post(y,X,a0,A0,var_eps)

% Estimated parameters
M    = X'*X;                                             % Sample precision matrix
b    = inv(M)*X'*y;                                      % Estimated b

% Prior parameters
b_0  = a0;                                               % Prior belief about b (AR coefficient)
M_0  = A0;                                               % Prior precision matrix (strength of belief)

% Posterior parameters (according to Luc Bauwens)
M_star = M_0 + M;
A_T    = inv(M_star);
b_star = A_T*(M_0*b_0 + M*b);                            % Slides: Conjugate prior, example 1
%a_T    = b_star;

% Drawing from posterior
%var_b  = A_T*var_eps;                                    % Conditioning on knowing var_eps (from previous draw)
% b_draw = b_star + randn(size(b_star,1),1);

% Kim&Nelson Variante: the prior precision matrix is defined as an inverse
% of the variance - covariance matrix --> the prior is informative if I
% choose a small value for M_0, then the inverse is larger and the weight
% on the prior is higher

b_star = inv(inv(M_0) + (1/var_eps)*M)*(inv(M_0)*b_0 + (1/var_eps)*M*b);
var_b  = inv(inv(M_0) + (1/var_eps)*M);

b_draw = b_star + chol(var_b)*randn(size(b_star,1),1); 

end
