% Use: draw random numbers for beta and variance from posterior destribution Bayesian regression model
% Ref: Frthwirth-Schnatter and Wagner, 2010, Journal of Econometrics

function [b_draw,var_eps_draw] = NIG_post2(y,x,a0,A0,c0,C0)
[T,k]=size(y);

% Posterior parameters
AT = inv(x'*x + inv(A0));
aT = AT*(x'*y + inv(A0)*a0);
cT = c0 + T/2;
CT = C0 + 0.5*(y'*y+a0'*inv(A0)*a0-aT'*inv(AT)*aT);

% Drawing var_eps from posterior IG
var_eps_draw = 1./gamrnd(cT,1/CT);

% Drawing coefs from posterior conditional on var_eps
var_b = AT*var_eps_draw;
b_draw = aT + chol(var_b)*randn(size(aT,1),1);


end
