function [p_bin,draw_bin,draw_b,draw_var] = Block1(w,z,a0,A0,c0,C0,p0,j,burn_ur,Model_bin,Sigma)
 
%% Sampling binary indictors
log_post_delta=zeros(1,2);

% calculate marginal likelihood and posterior model parameters for delta=0
z_r=z(:,1:end-1); a0_r=a0(1:end-1,:); A0_r=A0(1:end-1,1:end-1);

if Sigma==0
    [log_ml,aT0,AT0,cT0,CT0] = Bayesian_regr(w,z_r,a0_r,A0_r,c0,C0,Sigma);
else
    [log_ml,aT0,AT0] = Bayesian_regr(w,z_r,a0_r,A0_r,[],[],Sigma);
end
log_post_delta(1,1) = log_ml + log((1-p0));  
    
% calculate marginal likelihood and posterior model parameters for delta=1
[log_ml,aT1,AT1,cT1,CT1] = Bayesian_regr(w,z,a0,A0,c0,C0,Sigma);          
log_post_delta(1,2) = log_ml + log(p0);  

if Model_bin==0  
    p_bin = 0; draw_bin = 0;
else 
    if j<burn_ur
        p_bin = 1; draw_bin = 1;
    else
        e = exp(log_post_delta);
        p_bin = e(1,2)/sum(e); 
        if Model_bin==1  
            draw_bin = 1;
        elseif Model_bin==2                                                           
            draw_bin = binornd(1,p_bin);
        end
    end
end


%% Sampling variance and parameters conditional on binary indicator
if draw_bin==1
    % Drawing var from IG(cT,CT) 
    if Sigma==0; draw_var = 1./gamrnd(cT1,1/CT1); else draw_var=1; end;
    % Drawing parameters from N(aT,AT*var)
    var_b = AT1*draw_var;
    draw_b = aT1' + randn(1,size(aT1,1))*chol(var_b);   
else
    % Drawing var from IG(cT,CT) 
    if Sigma==0; draw_var = 1./gamrnd(cT0,1/CT0); else draw_var=1; end;
    % Drawing parameters from N(aT,AT*var)
    var_b = AT0*draw_var;
    draw_b = aT0' + randn(1,size(aT0,1))*chol(var_b);
    draw_b = [draw_b 0]; % set sigma parameter equal to zero
end   
 
end

