function stats = summary(draws)

if size(size(draws),2)==2

    [T,ndd]=size(draws);

    stats.mean = mean(draws,2);

    perc5=zeros(T,1)*NaN;perc95=zeros(T,1)*NaN;

    if ndd>10;

        temp = sort(draws,2);

        perc5 = temp(:,round(0.05*ndd));

        perc95 = temp(:,round(0.95*ndd));

    end

    stats.perc5 = perc5;

    stats.perc95 = perc95;

elseif size(size(draws),2)==3

    [T,N,ndd]=size(draws);

    stats.mean = mean(draws,3);

    perc5=zeros(T,N)*NaN;perc95=zeros(T,N)*NaN;

    for i=1:N

        temp = sort(draws(:,i,:),3);

        perc5(:,i) = temp(:,1,round(0.05*ndd));

        perc95(:,i) = temp(:,1,round(0.95*ndd));

    end

    stats.perc5 = perc5;

    stats.perc95 = perc95;

elseif size(size(draws),2)==4

    [T,N,n_cf,ndd]=size(draws);

    mean_=zeros(T,N,n_cf);perc5=zeros(T,N,n_cf);perc95=zeros(T,N,n_cf);

    for c=1:n_cf

        mean_(:,:,c) = mean(draws(:,:,c,:),4);

        for i=1:N

            temp = sort(draws(:,i,c,:),4);

            perc5(:,i,c) = temp(:,1,round(0.05*ndd));

            perc95(:,i,c) = temp(:,1,round(0.95*ndd));

        end

    end

    stats.mean=mean_;

    stats.perc5 = perc5;

    stats.perc95 = perc95;

end

