function [ prior_para ] = prior(T,A0)



bel_vepsy   = 0.01;        str_vepsy = 0.005;    c0_vepsy   = T*str_vepsy;  C0_vepsy    = c0_vepsy*bel_vepsy;      % 1: y
bel_vepsr   = 0.01;        str_vepsr = 0.005;    c0_vepsr   = T*str_vepsr;  C0_vepsr    = c0_vepsr*bel_vepsr;      % 2: r
bel_vepspi  = 1;           str_vepspi= 0.005;    c0_vepspi  = T*str_vepspi; C0_vepspi   = c0_vepspi*bel_vepspi;     % 3: pi
bel_vepsrc  = 1;           str_vepsrc= 0.005;    c0_vepsrc  = T*str_vepsrc; C0_vepsrc   = c0_vepsrc*bel_vepsrc;     % 4: z

mean_beta1         = 0.8;           var_beta1         = 0.1^2;    % 5: PC curve parameter, lag and expectations
mean_beta2         = 0.2;           var_beta2         = 0.1^2;    % 6: PC curve slope
mean_omega         = 0.9;           var_omega         = 0.1^2;    % 7: AR para in rgap
mean_phi1          = 1.55;          var_phi1          = 0.2^2;    % 8: AR1 para output gap
mean_sumphi        = 0.9;           var_sumphi        = 0.05^2;   % 9: Sum of AR para output gap 
mean_ar            = -0.1;          var_ar            = 0.035^2;  % 10: rgap impact on output gap
mean_kappa0        = 1;             var_kappa0        = 0.5^2;    % 11: kappa0
mean_z0            = 0;             var_z0            = 0.5^2;    % 12: z0
mean_h0_ystar      = log(.2);       var_h0_ystar      = 0.1^2;    % 13: h0_ystar 
mean_h0_ycycle     = log(.5);       var_h0_ycycle     = 0.1^2;    % 14: h0_ycycle
mean_sigma_kappa   = 0;             var_sigma_kappa   = A0^2;     % 15: sigma_kappa 
mean_sigma_z       = 0;             var_sigma_z       = A0^2;     % 16: sigma_z
mean_sigma_hystar  = 0;             var_sigma_hystar  = A0^2;     % 17: sigma_hystar
mean_sigma_hycycle = 0;             var_sigma_hycycle = A0^2;     % 18: sigma_hycycle


prior = [bel_vepsy bel_vepsr bel_vepspi bel_vepsrc mean_beta1 mean_beta2 mean_omega mean_phi1 mean_sumphi mean_ar mean_kappa0 mean_z0 mean_h0_ystar mean_h0_ycycle mean_sigma_kappa mean_sigma_z mean_sigma_hystar mean_sigma_hycycle; ...
         str_vepsy str_vepsr str_vepspi str_vepsrc var_beta1 var_beta2 var_omega var_phi1 var_sumphi var_ar var_kappa0 var_z0 var_h0_ystar var_h0_ycycle var_sigma_kappa var_sigma_z var_sigma_hystar var_sigma_hycycle  ];

prior = [prior zeros(2,8); zeros(4,26) ];   

for i=5:18
prior(4,i) = prior(1,i) - 1.96*sqrt(prior(2,i));
prior(5,i) = prior(1,i);
prior(6,i) = prior(1,i) + 1.96*sqrt(prior(2,i));
end

for a=1:4;

nn=100000;
sim_IG=zeros(nn,1);
    for k=1:nn
             sim_IG(k,1) = 1/gamrnd(T*prior(2,a),1/(T*prior(2,a)*prior(1,a))); 
    end
    prior(5,a) = median(sim_IG);
    prior(4,a) = prctile(sim_IG,5);
    prior(6,a) = prctile(sim_IG,95);
   
end   

varnames = {'eps_y_1'; 'eps_r_2'; 'eps_pi_3';'eps_rc_4';'beta1_5';'beta2_6';'omega_7';'phi1_8';'sum_phi_9';'ar_10';'kappa0_11';'z0_12';'h0_ystar_13';'h0_ycycle_14';'sigma_kappa_15';'sigma_z_16';'sigma_hystar_17';'sigma_hycycle_18'};
Table = array2table(prior(4:6,1:18),'VariableNames',varnames)

prior_para = prior;










end

