

function [dat2] = main_model(nd,bin,A0,spec,v)

dat2=0;

addpath('Procedures');
addpath('Data');
rng(3000); % set seed


%% Input section
Model_lam   = spec(1,1);                 % set to 2 for estimating prob of tv-growth, 1(0) for fixing indicator to 1(0) 
Model_z     = spec(1,2);                  % set to 2 for estimating prob of z, 1(0) for fixing indicator to 1(0)
Model_theta = [spec(1,3);  spec(1,4) ];            % set to 2 for estimating prob of SV
burn_ur     = bin;
N_vola      = 2;                % number of sv


data = csvread('data_repl.txt');

y          = data(:,1);
rr         = data(:,2);
pid        = data(:,3);
output_gap = data(:,4);
g_est      = data(:,5);
rstar_est  = data(:,6);
date       = data(:,7);
z_HLW      = data(:,8);
T = 223;

%% Priors
bel_vepsy   = 0.01;        str_vepsy = 0.0005;   c0_vepsy   = T*str_vepsy; C0_vepsy    = c0_vepsy*bel_vepsy; %  y
bel_vepsr   = 0.01;        str_vepsr = 0.0005;   c0_vepsr   = T*str_vepsr; C0_vepsr    = c0_vepsr*bel_vepsr; %  y
bel_vepsrc  = 0.5;         str_vepsrc= 0.005;    c0_vepsrc  = T*str_vepsrc; C0_vepsrc  = c0_vepsrc*bel_vepsrc; %  z
bel_vepspi  = 1;           str_vepspi= 0.005;    c0_vepspi  = T*str_vepspi; C0_vepspi  = c0_vepspi*bel_vepspi; %  z


a0_kappa = [0.75; 0];      A0_kappa  = [0.25^2  0; 0 A0^2];        % variance time-varying output drift: constant term and stdv
a0_z1    = [1; 0; 0];      A0_z1     = [(0.05)^2  0 0; 0 0.2^2 0; 0 0 A0^2]; 

a0_phi   = [1.55;0.95;-0.1];     A0_phi   = [0.25^2 0 0; 0 0.1^2 0; 0 0 0.03^2];  % AR Parameter and a_r
a0_omega = 0.95; A0_omega = 0.1^2;   
a0_beta  = [0.8;0.2]; A0_beta = [0.1^2 0; 0 0.1^2];  % Phillips curve parameter


a0_SV(:,:,1) = [log(0.2); 0];          A0_SV(:,:,1)   = [0.3^2 0; 0 A0^2];    % variance trend output
a0_SV(:,:,2) = [log(0.2); 0];          A0_SV(:,:,2)   = [0.3^2 0; 0 A0^2];    % variance output gap

p0=0.5;

%% Initialization Gibbs sampler
% Parameters
s_sigma_y     = sqrt(bel_vepsy);
s_sigma_r     = sqrt(bel_vepsr);
s_sigma_pi     = sqrt(bel_vepspi);
s_phi1        = a0_phi(1,1);
s_phi2        = a0_phi(2,1)-a0_phi(1,1);
s_kappa0      = a0_kappa(1,1);
s_sigma_kappa = a0_kappa(2,1);
s_sigma_gamma = [a0_SV(2,1,1);a0_SV(2,1,2)];
s_a_r         = -0.05;
s_z0          = 0;
s_sigma_z     = 0.15;
s_sigma_rc    = 1;
s_omega       = 0.9;
s_beta1       = 0.9;
s_beta2       = 0.8;
s_c           = 1;


% States
[hp_trend,hp_cycle] = hpfilter(y,12800);
s_ystar = hp_trend; s_cycle = hp_cycle;
s_kappa_tilde = zeros(T,1); s_kappa = s_kappa0 + s_sigma_kappa*s_kappa_tilde;

[hp_trend,hp_cycle] = hpfilter(rr,12800);
s_rstar = hp_trend; s_rc = hp_cycle;
s_z_tilde = zeros(T,1); s_z = s_z0 + s_sigma_z*s_z_tilde;


% Stochastic volatilities
load('table_mix10'); table_mix=table_mix10;
[iota]    = ini_sv(T,N_vola,table_mix);
s_h_tilde = cumsum(randn(T,N_vola));
s_h0      = [a0_SV(1,1,1);a0_SV(1,1,2)];%zeros(N_vola,1);
s_h       = [ones(T,1)*s_h0(1,1),ones(T,1)*s_h0(2,1)];%zeros(T,N_vola);

% Binary indicators
s_p_lambda = 0;
if Model_lam==0; s_lambda=0; else s_lambda=1; end
s_p_theta = zeros(N_vola,1); s_theta = zeros(N_vola,1);
if Model_theta(1,1)==0; s_theta(1,1)=0; else s_theta(1,1)=1; end
if Model_theta(2,1)==0; s_theta(2,1)=0; else s_theta(2,1)=1; end

%% Defining storage matrices
store_vepsy=[];
store_vepsr=[];
store_vepsz=[];
store_rstar=[];
store_vepspi=[];
store_cycle=[]; store_phi1=[]; store_phi2=[]; store_omega=[];  store_beta1=[]; store_beta2=[]; 
store_h0_cycle = []; store_h_cycle = []; store_sigma_gamma_cycle = []; store_theta_cycle = []; store_p_theta_cycle = [];

store_ystar=[];  store_kappa_filter=[]; store_rc=[]; store_rresid=[];
store_h0_ystar = []; store_h_ystar = []; store_sigma_gamma_ystar  = []; store_theta_ystar = []; store_p_theta_ystar = [];
store_kappa0 = []; store_z0 = []; store_kappa = []; store_z = []; store_sigma_kappa = []; store_sigma_z = []; store_lambda = []; store_p_lambda = []; store_lambdaz = []; store_p_lambdaz = [];
store_a_r=[]; store_vepsrc = []; store_c = [];
store_lambda_g = []; store_lambda_r = []; 
store_lambda_z = [];

store_states           = zeros(T,9,nd-bin); 
store_states_one_sided = zeros(T,9,nd-bin); 


%% Gibbs sampler
for j=1:bin+nd
     
    if (mod(j, 1000) ==0)
       disp([num2str([v j]) ' loops... ']);
    end
    
    % Potential output growth: binary indicator (s_lambda) and parameters (kappa0,stdv_kappa) 
    w = s_ystar - lagmatrix(s_ystar,1); w=w(2:end);   
    z=[ones(T-1,1) s_kappa_tilde(2:end)];  Sigma= (exp(s_h(2:end,1))).^2;  
    [s_p_lambda,s_lambda,draw_b]=Block1(w,z,a0_kappa,A0_kappa,[],[],p0,j,burn_ur,Model_lam,Sigma);
    s_kappa0=draw_b(1,1); s_sigma_kappa=draw_b(1,2);
    s_kappa = s_kappa0 + s_sigma_kappa*s_kappa_tilde; % Adjust s_kappa to new estimates s_kappa0 and s_sigma_kappa

 
     w = rr - s_omega*lagmatrix(rr,1);
     xx_1 = 4*s_kappa - s_omega*lagmatrix(4*s_kappa,1);
     xx_2 = (1-s_omega)*ones(T,1);
     xx_3 = s_z_tilde - s_omega*lagmatrix(s_z_tilde,1);
     
     w = w(2:end); xx = [xx_1(2:end) xx_2(2:end) xx_3(2:end)]; 
    
  [s_p_lambdaz,s_lambdaz,draw_bz,var_eps]=Block1(w,xx,a0_z1,A0_z1,c0_vepsr,C0_vepsr,p0,j,burn_ur,Model_z,0);
  
    s_c        = draw_bz(1,1); 
    s_z0       = draw_bz(1,2);
    s_sigma_z  = draw_bz(1,3);
    s_sigma_rc = sqrt(var_eps);
    s_z = s_z0 + s_sigma_z*s_z_tilde; 
    
    
    % Stochastic volatilities: binary indicators (s_theta) and parameters (h0,stdv_gamma)
    [w,Sigma] = SV_temp(T,N_vola,s_ystar,s_cycle,s_kappa,s_phi1,s_phi2,iota,table_mix);
    for k=1:N_vola
        z = 2*[ones(T,1) s_h_tilde(:,k)]; 
        [s_p_theta(k,1),s_theta(k,1),draw_b]=Block1(w(:,k),z,a0_SV(:,:,k),A0_SV(:,:,k),[],[],p0,j,burn_ur,Model_theta(k,1),Sigma(:,k));
        s_h0(k,1)=draw_b(1,1); s_sigma_gamma(k,1)=draw_b(1,2);  
    end
    s_h = repmat(s_h0',T,1) + s_h_tilde.*repmat(s_sigma_gamma',T,1); % Adjust s_h to new estimates s_h0 and s_sigma_gamma
    
    %% States 
    % Potential output and cycle
    
    pi_ss = pid-s_beta1*(lagmatrix(pid,1));
   
  
    [states,states_onesided]  = states5(y,pi_ss,s_beta2,s_sigma_pi,T,s_sigma_kappa,s_phi1,s_phi2,s_sigma_y,s_kappa0,s_lambda,s_h,rr,s_a_r,s_sigma_z,s_sigma_rc,s_omega,s_sigma_r,s_z0,s_c);
 
    s_ystar         = states(:,1);
    s_kappa_tilde   = states(:,2);
    s_z_tilde       = states(:,3);
    s_rc            = states(:,4);
    s_cycle         = states(:,5);
    s_kappa         = states(:,6);
    s_z             = states(:,7);
    s_rstar         = states(:,8);
    
      
   

  %% Parameters
    
   
    [s_phi1,s_phi2,s_a_r] = block_rho(s_cycle,s_h(:,2),a0_phi,A0_phi,s_phi1,s_phi2,1,0.5*(lagmatrix(s_rc,1)+lagmatrix(s_rc,2)),s_a_r);

       
    ydata = s_rc;  ydata = ydata(2:end);
    xdata = lagmatrix(s_rc,1); xdata = xdata(2:end);
    
    [b_draw] = N_post(ydata,xdata,a0_omega,A0_omega,s_sigma_rc^2);
    if b_draw < 1; 
        s_omega    = b_draw;
    end
    

    





      ydata2 = pid;  ydata2 = ydata2(2:end);
      xdata2 = lagmatrix(pid,1); xdata2 = [xdata2(2:end) s_cycle(2:end)];
      
      [para sigma_pi ] = NIG_post2(ydata2,xdata2,a0_beta,A0_beta,c0_vepspi,C0_vepspi);
      
      s_beta1    = para(1,1);
      s_beta2    = para(2,1);
      s_sigma_pi = sqrt(sigma_pi);    
  
    
    
    % Stochastic volatilities: states (s_h, s_h_tilde)
    [s_h_tilde,s_h,iota] = Block2(T,s_ystar,s_cycle,s_kappa,s_h,s_phi1,s_phi2,s_h0,s_sigma_gamma,s_theta,table_mix);

    %% Random sign switch 
    sign=1; sign_switch=rand; if sign_switch>0.5; sign=-1; end
    s_sigma_kappa = sign*s_sigma_kappa; s_kappa_tilde = sign*s_kappa_tilde;
    s_sigma_z     = sign*s_sigma_z;     s_z_tilde     = sign*s_z_tilde;
    
    for k=1:2
        sign=1; sign_switch=rand; if sign_switch>0.5; sign=-1; end
        s_sigma_gamma(k,1) = sign*s_sigma_gamma(k,1); s_h_tilde(:,k) = sign*s_h_tilde(:,k); 
    end    
    
    %% Storing results
    if j>bin  
        
        store_states_one_sided(:,:,j-bin) = states_onesided; 
        
        
        
    
            store_kappa                    = [store_kappa s_kappa];
            store_sigma_kappa              = [store_sigma_kappa s_sigma_kappa];
            
            store_z                        = [store_z s_z];
            store_sigma_z              = [store_sigma_z s_sigma_z];
            
    
            store_h_ystar           = [store_h_ystar exp(s_h(:,1))];   
            store_sigma_gamma_ystar = [store_sigma_gamma_ystar s_sigma_gamma(1,1)];
    
            store_h_cycle            = [store_h_cycle exp(s_h(:,2))];   
            store_sigma_gamma_cycle  = [store_sigma_gamma_cycle s_sigma_gamma(2,1)];
     
        
        store_kappa0         = [store_kappa0 s_kappa0];
        store_lambda         = [store_lambda s_lambda]; 
        store_p_lambda       = [store_p_lambda s_p_lambda];
       
        store_z0              = [store_z0 s_z0];
        store_lambdaz         = [store_lambdaz s_lambdaz]; 
        store_p_lambdaz       = [store_p_lambdaz s_p_lambdaz];
        
        
        
        store_h0_ystar       = [store_h0_ystar exp(s_h0(1,1))];
        store_theta_ystar    = [store_theta_ystar s_theta(1,1)]; 
        store_p_theta_ystar  = [store_p_theta_ystar s_p_theta(1,1)];
        
        store_h0_cycle       = [store_h0_cycle exp(s_h0(2,1))];
        store_theta_cycle    = [store_theta_cycle s_theta(2,1)]; 
        store_p_theta_cycle  = [store_p_theta_cycle s_p_theta(2,1)];
        
        store_ystar          = [store_ystar s_ystar];
        store_cycle          = [store_cycle s_cycle];
        store_rstar          = [store_rstar s_rstar];
        
        store_phi1           = [store_phi1 s_phi1];
        store_phi2           = [store_phi2 s_phi2];
        store_beta1          = [store_beta1 s_beta1];
        store_beta2          = [store_beta2 s_beta2];
        
        store_omega          = [store_omega s_omega];
        store_a_r            = [store_a_r s_a_r];
        store_vepsrc         = [store_vepsrc s_sigma_rc];
        store_vepsz          = [store_vepsz s_sigma_z];
        store_vepsy          = [store_vepsy s_sigma_y];
        store_vepsr          = [store_vepsr s_sigma_r];
        store_vepspi         = [store_vepspi s_sigma_pi];
        store_c              = [store_c s_c];
        
        store_lambda_g      = [store_lambda_g abs(s_sigma_kappa)/exp(s_h0(1,1)) ];
        
        sig_gg = abs(4*s_sigma_kappa); 
        store_lambda_r      = [store_lambda_r sqrt(s_c^2*sig_gg^2)  ];
        
        
        store_rc             = [store_rc s_rc];
        
    end      
end

%% Summarizing the results
mean_states_onesided    = mean(store_states_one_sided(:,:,:),3);   
lower_states_onesided   = prctile(store_states_one_sided(:,:,:),5,3);
upper_states_onesided   = prctile(store_states_one_sided(:,:,:),95,3);



results.cycle = summary(store_cycle);
results.ystar = summary(store_ystar);
results.rstar = summary(store_rstar);
results.rc = summary(store_rc);
results.rresid = summary(store_rresid);
results.z = summary(store_z);
if Model_theta(2,1)>0;   results.hc     = summary(store_h_cycle); end
if Model_theta(1,1)>0;   results.hystar = summary(store_h_ystar); end
if Model_lam>0;          results.kappa  = summary(store_kappa);
                         results.kappa_filter  = summary(store_kappa_filter);
end

%% Table

if v == 2;
LastName = {'pot-growth';'z';'SV-cycle';'SV-ystar'};
Mean_Indic = [mean(store_lambda,2);mean(store_lambdaz,2);mean(store_theta_cycle,2);mean(store_theta_ystar,2)];
Mean_Prob  = [mean(store_p_lambda,2);mean(store_p_lambdaz,2);mean(store_p_theta_cycle,2);mean(store_p_theta_ystar,2)];
Mean_Indic_Prob = [Mean_Indic Mean_Prob];
Tab = table(Mean_Indic_Prob,'RowNames',LastName)
end


if v==3;
LastName = {'sig-pi';'sig-z';'sig-rc';'beta-1';'beta_2';'phi-1';'phi-2';'omega';'a_r';'kappa_0';'z_0';'abs(std_kappa)';'h0_ystar';'abs(std_gam_ystar)';'h0_cycle';'abs(std_gam_cycle)';'c';'lambda_g';'sig_rstar'};
Mean_Percentile = [[mean(store_vepspi) prctile(store_vepspi,5) prctile(store_vepspi,95)];...
                   [mean(store_vepsz) prctile(store_vepsz,5) prctile(store_vepsz,95)];...
                   [mean(store_vepsrc) prctile(store_vepsrc,5) prctile(store_vepsrc,95)];...
                   [mean(store_beta1)  prctile(store_beta1,5) prctile(store_beta1,95) ];...
                   [mean(store_beta2)  prctile(store_beta2,5) prctile(store_beta2,95) ];...
                   [mean(store_phi1)  prctile(store_phi1,5) prctile(store_phi1,95) ];...
                   [mean(store_phi2)  prctile(store_phi2,5) prctile(store_phi2,95)];...
                   [mean(store_omega)  prctile(store_omega,5) prctile(store_omega,95)];...
                   [mean(store_a_r)  prctile(store_a_r,5) prctile(store_a_r,95)];...
                   [mean(store_kappa0) prctile(store_kappa0,5) prctile(store_kappa0,95)];... 
                   [mean(store_z0) prctile(store_z0,5) prctile(store_z0,95)];... 
                   [mean(abs(store_sigma_kappa)) prctile(abs(store_sigma_kappa),5) prctile(abs(store_sigma_kappa),95)];...                
                   [mean(store_h0_ystar) prctile(store_h0_ystar,5) prctile(store_h0_ystar,95)];...
                   [mean(abs(store_sigma_gamma_ystar)) prctile(abs(store_sigma_gamma_ystar),5) prctile(abs(store_sigma_gamma_ystar),95)];...  
                   [mean(store_h0_cycle) prctile(store_h0_cycle,5) prctile(store_h0_cycle,95)];...
                   [mean(abs(store_sigma_gamma_cycle)) prctile(abs(store_sigma_gamma_cycle),5) prctile(abs(store_sigma_gamma_cycle),95)];...      
                   [mean(store_c)  prctile(store_c,5) prctile(store_c,95)];...  
                   [mean(store_lambda_g)  prctile(store_lambda_g,5) prctile(store_lambda_g,95)];... 
                   [mean(store_lambda_r)  prctile(store_lambda_r,5) prctile(store_lambda_r,95)]]; 
Tab = table(Mean_Percentile,'RowNames',LastName)
end


 

if v==3;
    
  
 
figure

    subplot(3,2,1); confplot(date(2:end),[mean_states_onesided(2:end,7) rstar_est(2:end,1) ],lower_states_onesided(2:end,7), upper_states_onesided(2:end,7)); legend('HLW','model-one'); title('r-star-one');
    subplot(3,2,2); confplot(date(2:end),[mean_states_onesided(2:end,4) rr(2:end,1)-rstar_est(2:end,1)],lower_states_onesided(2:end,4), upper_states_onesided(2:end,4)); legend('HLW','model-one'); title('hc');  
    subplot(3,2,3); confplot(date(2:end),[mean_states_onesided(2:end,8) g_est(2:end,1)*0.25], lower_states_onesided(2:end,8),upper_states_onesided(2:end,8));legend('HLW','model');title('Potential output growth');
    subplot(3,2,4); confplot(date(2:end),[mean_states_onesided(2:end,9) z_HLW(2:end,1) ],lower_states_onesided(2:end,9),upper_states_onesided(2:end,9)); legend('HLW','model'); title('z'); 
    subplot(3,2,5); confplot(date(2:end),[mean_states_onesided(2:end,5) output_gap(2:end,1) zeros(T-1,1) ],lower_states_onesided(2:end,5),upper_states_onesided(2:end,5)); legend('HLW','model'); title('output gap'); 
    subplot(3,2,6); confplot(date(2:end),results.hc.mean(2:end,1),results.hc.perc5(2:end,1), results.hc.perc95(2:end,1)); legend('hc'); title('hc'); 
 
 
end
    
   if v==1; 
    figure
    subplot(1,4,1); histogram(store_sigma_kappa); title('sigma - Potential output growth');
    subplot(1,4,2); histogram(store_sigma_z); title('sigma - z');
    subplot(1,4,3); histogram(store_sigma_gamma_cycle);   title('sigma - Output gap');
    subplot(1,4,4); histogram(store_sigma_gamma_ystar);   title('sigma - Potential Output');
   end   
    