%% Approximating the distribution of log(e^2) by a mixture of normals
%the means and variances of the mixture and the mixture weights in 'table' were chosen to match the first four moments of the log X2 distribution 

function ind_s = ind_calc2(y,h_hat,sigma2,table)

[T,N]=size(y);
mix=size(table,1);

ind_s=zeros(T,1);
kapstar=y-2*h_hat-log(sigma2);

for t=1:T
   pval=zeros(mix,1);
   for k=1:mix
      pval(k,1)=table(k,2)*inv(sqrt(table(k,4)))*exp(-((kapstar(t,1)-table(k,3)+1.2704)^2)/(2*table(k,4)));
   end
   %[C,ind_s(t,1)] = max(pval);
   % Drawing from discrete distribution with probabilities in pval 
   cs_pval = cumsum(pval); %making intervals using the probabilities
   draw=rand(1)*cs_pval(mix,1); %multiply by sum of Pvals as these do not sum up to 1 (as they are only defined up to a proportional constant)
   ind_s(t,1)=find(cs_pval>draw,1); % find the first number in cs_pval that is larger than the draw
end