function [Ssim]=Ksampler(hStt,hPtt,Qt,Ttt,Ktt,mu)

[ns,T] = size(hStt);
d = size(mu,2);

mean = hStt(:,T);
var = hPtt(:,:,T);

Ssim = zeros(T,ns);
[R,p] = chol(var);
if p>0; R=fix_var(var,ns); end
Ssim(T,:) = mean' + randn(1,ns)*R; 

for t=T-1:-1:1
    Stt = hStt(:,t);
    Ptt = hPtt(:,:,t);
    
    Tt = Ttt(:,:,t);
    Kt = Ktt(:,:,t);
    
    St = Tt*Stt;
    %if size(Q,3)==T; Qt=Q(:,:,t); else; Qt=Q; end
    Pt = Tt*Ptt*Tt' + Kt*Qt*Kt';
    Pttt = Ptt*Tt';
    
    if d==0
        mean = Stt + Pttt*inv(Pt)*(Ssim(t+1,1:size(Tt,1))'-St);
        
        
    elseif d==1
        mean = Stt + Pttt*inv(Pt)*(Ssim(t+1,1:size(Tt,1))'-mu-St);
       
    else
        mean = Stt + Pttt*inv(Pt)*(Ssim(t+1,1:size(Tt,1))'-mu(:,t)-St);  
        
    end
    var = Ptt - Pttt*inv(Pt)*Pttt';
    
    
    [R,p] = chol(var);
    if p>0; R=fix_var(var,ns); end
    
    
    Ssim(t,:) = mean' + randn(1,ns)*R; 
end

end  


function R=fix_var(var,ns)
   % var
    fprintf('Var is not positive definite: trying to fix problem');
    R=zeros(ns,ns);
    for i=1:ns
       if var(i,i)>0
          R(i,i)=sqrt(var(i,i));
       else
          R(i,i)= 0.001;
       end
    end
end