function [s_ystar,s_kappa_tilde,s_kappa,s_cycle] = Block_TVP(y,T,s_sigma_kappa,s_phi1,s_phi2,s_vepsy,det_kappa0,s_lambda,s_h)


%% Setting up SS matrices
ns = 4; dim = 3;

if size(s_h,2)==3; s_sigma_kappa=exp(s_h(:,3)); else s_sigma_kappa=ones(1,1,T)*s_sigma_kappa; end

Zt = zeros(1,ns,T);     Zt(1,1,:) = 1;  Zt(1,3,:) = 1;
Ht = zeros(1,1,T);      Ht(1,1,:) = s_vepsy;
At = [];

mu=zeros(4,T);          mu(1,:)=det_kappa0';
Tt = zeros(ns,ns,T);    Tt(1,1,:)=1; Tt(2,2,:)=1; Tt(1,2,:)=s_sigma_kappa; Tt(3,3,:)=ones(1,1,T)*s_phi1; Tt(3,4,:)=ones(1,1,T)*s_phi2; Tt(4,3,:)=1;   
Kt = zeros(ns,dim,T);   Kt(1,1,:) = exp(s_h(:,1)); Kt(2,2,:) = 1; Kt(3,3,:) = exp(s_h(:,2));
Qt = eye(dim);

%% Initialisation
S0=zeros(ns,1); S0(1,1)=y(1,1);  

P0=eye(4).*1000; P0(2,2)=0.001;

var_AR2 = (exp(s_h(1,2)))^2*(1-s_phi2)/((1+s_phi2)*(1-s_phi1-s_phi2)*(1+s_phi1-s_phi2));
cov_AR2 = s_phi1*var_AR2/(1-s_phi2);
P0(3:4,3:4)=[var_AR2 cov_AR2; cov_AR2 var_AR2];

%tmp=inv(eye(2^2)-kron(Tt(3:4,3:4),Tt(3:4,3:4)))*reshape(Kt(3:4,3)*Qt(3,3)*Kt(3:4,3)',2*2,1); % Calculate variance AR(p) process
%P0(3:4,3:4)=reshape(tmp',2,2);

%% Kalman filter and sampler
if s_lambda==0 % drop kappa_tilde from matrices
    Zt(:,2,:)=[];S0(2,:)=[];P0(:,2)=[];P0(2,:)=[];Qt(:,2)=[];Qt(2,:)=[];Tt(:,2,:)=[];Tt(2,:,:)=[];Kt(:,2,:)=[];Kt(2,:,:)=[];mu(2,:)=[];
end
[hStt,hPtt] = Kfilter_um(y,Zt,At,S0,P0,Qt,Tt,Kt,Ht,mu);

if s_lambda==1  
    [draws] = Ksampler(hStt,hPtt,Qt,Tt(1:3,:,:),Kt(1:3,:,:),mu(1:3,:)); % adjusted to sample 'only' the first 3 states (as 4th is just lag of the 3th)!
    s_ystar = draws(:,1); s_kappa_tilde = draws(:,2); s_cycle = draws(:,3);
else 
    [draws] = Ksampler(hStt,hPtt,Qt,Tt(1:2,:,:),Kt(1:2,:,:),mu(1:2,:)); % adjusted to sample 'only' the first 2 states (as 3th is just lag of the 2th)!
    s_ystar = draws(:,1); s_kappa_tilde = cumsum(randn(T,1)); s_cycle = draws(:,2);
end
  
%% Reconstructing time-varying kappa
s_kappa = det_kappa0 + squeeze(s_sigma_kappa).*s_kappa_tilde;                         % equal to s_kappa0 if s_lambda=0 (s_sigma_kappa=0 in this case)    

end
