function [p_bin,draw_bin,draw_b,draw_var] = Block1b(w,z,a0,A0,c0,C0,p0,Sigma,j,burn_ur,Model_bin,draw_bin)

%% Sampling binary indictors
K=size(a0,1)-1;
p_bin=zeros(K,1);
seq = randsample(3,3)'; % randomize the sequence in which the binary indicators are drawn

for k=1:K
    ki=seq(1,k);
    if Model_bin(ki,1)==0                           
        p_bin(ki,1) = 0; draw_bin(ki,1) = 0;
    else      
        if j<burn_ur
            p_bin(ki,1) = 1; draw_bin(ki,1) = 1;
        else
            p_bin(ki,1) = p_bin_calc(w,z,draw_bin,a0,A0,c0,C0,p0,Sigma,1,ki);
            if Model_bin(ki,1)==1
                draw_bin(ki,1) = 1;
            elseif Model_bin(ki,1)==2
                draw_bin(ki,1) = binornd(1,p_bin(ki,1));                                                    
            end
        end
    end
end

%% Sampling variance and parameters conditional on binary indicators
% Restricting matrices according to binary indicators in draw_bin
I0 = find(draw_bin==0);                                                    % construct index indicating which binary indicators are zero
a0r=a0; a0r(1+I0,:)=[];                                                    % imposing restrictions implied by binary indicators
A0r=A0; A0r(:,1+I0)=[]; A0r(1+I0,:)=[];
zr=z; zr(:,1+I0)=[];

% Drawing var_eps from posterior IG and coefs from posterior conditional on var_eps
[~,aT,AT,cT,CT] = Bayesian_regr(w,zr,a0r,A0r,c0,C0,Sigma);                         
if Sigma==0; draw_var = 1./gamrnd(cT,1/CT); else draw_var=1; end;
var_b = AT*draw_var;
draw_tmp = aT + (randn(1,size(aT,1))*chol(var_b))';

% storing results
draw_b = zeros(size(draw_bin,1),1);
draw_b(draw_bin==1,1) = draw_tmp(2:end,1);                                 % storing non-zero stdv values 
draw_b = [draw_tmp(1,1);draw_b];                                           % first element is allways included   
 
 
end

