
**** change directory to main folder *****
cd ""

use "./nlsy97/RFdata.dta", clear
cd "./stata"

bys id: gen index=1 if _n==1

tab gender, gen(gender_) 
rename gender_1 male

gen races= 1 if race_eth==1
replace races= 2 if race_eth==2
replace races= 3 if race==1 & races==.

tab races, gen(race_)

rename race_1 black
rename race_2 hispanic
rename race_3 white

gen black_male = male*black
gen hispanic_male = male*hispanic
gen white_male = male*white

gen col_age24=1 if hgc24>=13 & hgc24<=20
replace col_age24=0 if hgc24<13 & hgc24~=.

gen educ=1 if hgc24<12 & hgc24~=.
replace educ=2 if hgc24==12
replace educ=3 if hgc24>12 & hgc24~=.

rename num_hh_under18 family_members

gen susp=1 if days_suspended>0 & days_suspended~=.
replace susp=0 if days_suspended==0 

gen arrest=1 if num_arrest>0 & num_arrest~=.
replace arrest=0 if num_arrest==0

tab mom_parent_style, gen(parental_)

rename parental_1 uninvolved
rename parental_2 permissive
rename parental_3 authoritarian
rename parental_4 authoritative

gen brokenhh_male=brokenhh*male
gen family_members_male=family_members*male

tab momdegree if momdegree~=0, gen(m_degree_)

gen m_degree_1_male=m_degree_1*male
gen m_degree_2_male=m_degree_2*male
gen m_degree_3_male=m_degree_3*male
gen m_degree_4_male=m_degree_4*male

tab daddegree if daddegree~=0, gen(d_degree_)


label var white "White"
label var black "Black"
label var hispanic "Hispanic"
label var brokenhh "Broken Family"
label var family_members "Fam. Mem. under Age 18" 
label var family_income "Family Income"
label var piat "PIAT"
label var asvab_ar_age_normed "Arithmetic Reasoning"
label var asvab_mk_age_normed "Mathematical Knowledge"
label var asvab_pc_age_normed "Paragraph Comprehension"
label var asvab_wk_age_normed "Word Knowledge"
label var gpain8 "GPA grade 8"
label var susp "Suspensions"
label var sex "Precocious Sex" 
label var retention "School Retention"
label var arrest "Arrest"
label var black_male "Black x Male" 
label var hispanic_male "Hispanic x Male"
label var white_male "White x Male"
label var m_degree_2 "Mother Educ - High School"
label var m_degree_3 "Mother Educ - Some College"
label var m_degree_4 "Mother Educ - College Grad."


gen substance=1 if (marij==1 | alcohol==1 | smoke==1)
replace substance=0 if (marij==0 & alcohol==0 & smoke==0)

*Table 1
tab educ if index==1 & black==1 & male==1 [aw=wt_r1]
tab educ if index==1 & black==1 & male==0 [aw=wt_r1]
tab educ if index==1 & white==1 & male==1 [aw=wt_r1]
tab educ if index==1 & white==1 & male==0 [aw=wt_r1]
tab educ if index==1 & hispanic==1 & male==1 [aw=wt_r1]
tab educ if index==1 & hispanic==1 & male==0 [aw=wt_r1]

*Tables 3 and 4
est clear
eststo: quietly reg m_degree_4 white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg family_members white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg brokenhh white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg family_income white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
esttab using fam_sum.csv, b(%8.2f) star(* 0.10 ** 0.05 *** 0.01 )  not

local W "brokenhh family_members m_degree_2 m_degree_3 m_degree_4"
foreach var of local W {
	capture confirm numeric variable `var'
	if _rc==0 {
		quietly sum `var'
		replace `var'=`var'-r(mean)
	} 
	else di "`var' is not a numeric variable and cannot be demeaned."
}



est clear
eststo: quietly reg col_age24 black hispanic white_male black_male hispanic_male [pw=wt_r1] if brokenhh~=. & m_degree_1~=. & family_members~=.
esttab using fam_base_reg.csv, b(%8.3f) star(* 0.10 ** 0.05 *** 0.01 ) se not wide

est clear
eststo: quietly reg col_age24 black hispanic white_male black_male hispanic_male brokenhh family_members m_degree_2 m_degree_3 m_degree_4  if index==1 [pw=wt_r1]
esttab using fam_control_reg.csv, b(%8.3f) star(* 0.10 ** 0.05 *** 0.01 ) se not wide

est clear
eststo: quietly reg susp white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg retention white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg gpain8 white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg sex white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg attack white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg substance white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
esttab using behave_sum.csv, b(%8.2f) star(* 0.10 ** 0.05 *** 0.01 )  not

local P "susp sex gpain8 retention attack substance"
foreach var of local P {
	capture confirm numeric variable `var'
	if _rc==0 {
		quietly sum `var'
		replace `var'=`var'-r(mean)
	} 
	else di "`var' is not a numeric variable and cannot be demeaned."
}

est clear
eststo: quietly reg col_age24 black hispanic white_male black_male hispanic_male [pw=wt_r1] if susp~=. & sex~=.  & gpain8~=. & retention~=. & attack~=. & substance~=.
esttab using behave_base_reg.csv, b(%8.3f) star(* 0.10 ** 0.05 *** 0.01 )  se not wide

est clear
eststo: quietly reg col_age24 black hispanic white_male black_male hispanic_male susp sex gpain8 retention attack substance [pw=wt_r1] if susp~=. & sex~=. & gpain8~=. & retention~=.
esttab using behave_control_reg.csv, b(%8.3f) star(* 0.10 ** 0.05 *** 0.01 ) se not wide

est clear
eststo: quietly reg asvab_ar_age_normed white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon 
eststo: quietly reg asvab_mk_age_normed white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg asvab_pc_age_normed white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
eststo: quietly reg asvab_wk_age_normed white black hispanic white_male black_male hispanic_male [pw=wt_r1], nocon
esttab using math_verb_sum.csv, b(%8.2f) star(* 0.10 ** 0.05 *** 0.01 )  not

local D "asvab_ar_age_normed asvab_mk_age_normed asvab_wk_age_normed asvab_pc_age_normed"
foreach var of local D {
	capture confirm numeric variable `var'
	if _rc==0 {
		quietly sum `var'
		replace `var'=`var'-r(mean)
	} 
	else di "`var' is not a numeric variable and cannot be demeaned."
}

est clear
eststo: quietly reg col_age24 black hispanic white_male black_male hispanic_male [pw=wt_r1] if asvab_ar_age_normed~=. & asvab_mk_age_normed~=. & asvab_wk_age_normed~=. & asvab_pc_age_normed~=. 
esttab using math_verb_base_reg.csv, b(%8.3f) star(* 0.10 ** 0.05 *** 0.01 ) se not wide

est clear
eststo: quietly reg col_age24 black hispanic white_male black_male hispanic_male asvab_ar_age_normed asvab_mk_age_normed asvab_wk_age_normed asvab_pc_age_normed [pw=wt_r1]
esttab using math_verb_control_reg.csv, b(%8.3f) star(* 0.10 ** 0.05 *** 0.01 ) se not wide

