function OUTPUT = ReducedFormGaps(DATA,RF)

T = 9;

DATA = rmfield(DATA,{'hgc','t'});
[DATA(:).hgc] = deal(9);
[DATA(:).t] = deal(1);

calcpr = @(D) ( D(end).pwt'*(D(end).hgc>=13) )./sum(D(end).pwt);

RFgap = zeros(3,3);
r = 1;
for g = [1 3 5]
    
    D = DATA(ismember(vertcat(DATA.grp),[g (g+1)]'));
    
    for m = 1:3
        pr_m = calcpr(SimulateData(D,RF(m),T+1,'grp',g));
        pr_f = calcpr(SimulateData(D,RF(m),T+1,'grp',g+1));
        RFgap(m,r) = pr_m - pr_f;
    end
    r = r+1;    
end
        
RFgap = RFgap(:,[2 1 3]); %Re-order race;
RFgap = RFgap([3 2 1],:); %Re-order Model Order;

rownames = {'Time only','Time and disruption only','Time, disruption, and arrest only'};

OUTPUT = struct();
OUTPUT.RFgap = [rownames' num2cell(RFgap)];
